/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.config.ConfigProperty;
import com.cenqua.fisheye.config.PropertiesContainer;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.LRULinkedHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class PassivateManager {
    public static final long DEFAULT_CACHE_SIZE = 0x500000L;
    public static final long DEFAULT_MAX_TOTAL_CACHE_SIZE;
    public static final int DEFAULT_MAX_ACTIVE = 50;
    public static final long DEFAULT_MIN_CACHE_SIZE = 0x100000L;
    private long MAX_TOTAL_CACHE_SIZE = DEFAULT_MAX_TOTAL_CACHE_SIZE;
    private int MAX_ACTIVE = 50;
    private long MIN_CACHE_SIZE = 0x100000L;
    private final Object lock = new Object();
    private final Set<RepositoryHandle> runnable = new HashSet<RepositoryHandle>();
    private final LRULinkedHashMap<RepositoryHandle, Object> activeOkay = new LRULinkedHashMap(true);
    private final LinkedHashSet<RepositoryHandle> activeNeedingPassivation = new LinkedHashSet();
    private final BackgroundThread backgroundThread = new BackgroundThread();
    private volatile long cacheSize = 0x500000L;

    public PassivateManager() {
        Logs.APP_LOG.info((Object)("Cache-sizing: MAX_TOTAL_CACHE_SIZE=" + this.MAX_TOTAL_CACHE_SIZE));
        this.startBackgroundTask();
    }

    private void startBackgroundTask() {
        Thread t = new Thread((Runnable)this.backgroundThread, "Passivation thread");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ConfigDocument.Config props) {
        Object object = this.lock;
        synchronized (object) {
            PropertiesContainer[] p = new PropertiesContainer[]{RootConfig.asPropertiesContainer(props)};
            ConfigProperty propMaxTotalCacheSize = new ConfigProperty(p, "repcache.memcache.total_size", Long.toString(DEFAULT_MAX_TOTAL_CACHE_SIZE));
            ConfigProperty propMaxActive = new ConfigProperty(p, "repcache.passivate.soft_max_active", Long.toString(50L));
            this.MAX_TOTAL_CACHE_SIZE = propMaxTotalCacheSize.getComputingUnitValue();
            this.MAX_ACTIVE = propMaxActive.getIntValue();
            this.MIN_CACHE_SIZE = 0x100000L;
            Logs.APP_LOG.info((Object)("Cache-sizing: " + propMaxTotalCacheSize.getName() + "=" + this.MAX_TOTAL_CACHE_SIZE));
            Logs.APP_LOG.info((Object)("Cache-sizing: " + propMaxActive + "=" + this.MAX_ACTIVE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForPassivation(boolean checkAll) {
        ArrayList<RepositoryHandle> handles;
        Object object = this.lock;
        synchronized (object) {
            handles = new ArrayList<RepositoryHandle>(checkAll ? this.runnable : this.activeNeedingPassivation);
        }
        for (RepositoryHandle handle : handles) {
            handle.checkForPassivation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsPassivation(RepositoryHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            return this.activeNeedingPassivation.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long repositoryBecameRunnable(RepositoryHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            this.runnable.add(handle);
            this.recalc();
            return this.cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repositoryNoLongerRunnable(RepositoryHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            this.runnable.remove(handle);
            this.activeOkay.remove(handle);
            this.activeNeedingPassivation.remove(handle);
            this.recalc();
        }
    }

    private void recalc() {
        int nRunnable = this.runnable.size();
        if (nRunnable == 0) {
            this.cacheSize = this.MAX_TOTAL_CACHE_SIZE;
            return;
        }
        long v = this.MAX_TOTAL_CACHE_SIZE / (long)Math.min(this.MAX_ACTIVE, nRunnable);
        this.cacheSize = Math.max(v, this.MIN_CACHE_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnRelease(RepositoryHandle handle, boolean isPassive) {
        Object object = this.lock;
        synchronized (object) {
            if (isPassive) {
                this.activeNeedingPassivation.remove(handle);
                this.activeOkay.remove(handle);
            } else {
                this.activeOkay.put(handle, null);
                this.activeNeedingPassivation.remove(handle);
                if (this.activeOkay.size() > this.MAX_ACTIVE) {
                    RepositoryHandle last = this.activeOkay.popLRUKey();
                    this.activeNeedingPassivation.add(last);
                    this.backgroundThread.wakeNow();
                }
            }
        }
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    static {
        long mx = Runtime.getRuntime().maxMemory();
        if (mx == Long.MAX_VALUE) {
            Logs.APP_LOG.info((Object)"Max memory unbounded, assuming 64MB for cache-sizing");
            mx = 0x4000000L;
        }
        if (mx <= 0L) {
            Logs.APP_LOG.info((Object)"Max memory <= 0, assuming 64MB for cache-sizing");
            mx = 0x4000000L;
        }
        DEFAULT_MAX_TOTAL_CACHE_SIZE = mx / 3L;
    }

    private class BackgroundThread
    implements Runnable {
        private static final long PERIOD = 60000L;
        private final Object backgroundLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long nextCheckAllTime = System.currentTimeMillis() + 60000L;
            while (true) {
                Object object = this.backgroundLock;
                synchronized (object) {
                    try {
                        long delay = Math.max(1L, nextCheckAllTime - System.currentTimeMillis());
                        this.backgroundLock.wait(delay);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
                try {
                    boolean checkAll = false;
                    long now = System.currentTimeMillis();
                    if (now >= nextCheckAllTime) {
                        checkAll = true;
                        nextCheckAllTime = now + 60000L;
                    }
                    PassivateManager.this.checkForPassivation(checkAll);
                    continue;
                }
                catch (Throwable e3) {
                    Logs.APP_LOG.warn((Object)"Problem during passivation check", e3);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeNow() {
            Object object = this.backgroundLock;
            synchronized (object) {
                this.backgroundLock.notify();
            }
        }
    }
}

