/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.CacheWarmer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryEventMulticaster;
import com.cenqua.fisheye.rep.RepositoryListener;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.ReviewInfoDAO;
import com.cenqua.fisheye.vis.LineCountDatasetProducer;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import java.io.File;
import java.io.IOException;

public abstract class RepositoryEngine {
    private static final CacheWarmer WARMER = new CacheWarmer();
    protected final RepositoryConfig cfg;
    protected final File cacheDir;
    private DirTreeCache dtcache = null;
    private LineCountDatasetProducer datasetProducer = null;
    private long infDbCacheSize = 0x500000L;
    private final RepositoryEventMulticaster eventMulticaster = new RepositoryEventMulticaster();
    private BucketGraph bucketGraph = null;

    public RepositoryEngine(RepositoryConfig cfg) {
        this.cfg = cfg;
        this.cacheDir = RepositoryEngine.cacheDir(cfg);
        cfg.getStatus().setDoneFullSlurp(false);
    }

    public RepositoryConfig getCfg() {
        return this.cfg;
    }

    public void addListener(RepositoryListener l) {
        this.eventMulticaster.addListener(l);
    }

    public void removeListener(RepositoryListener l) {
        this.eventMulticaster.removeListener(l);
    }

    public LineCountDatasetProducer getDatasetProducer() {
        return this.datasetProducer;
    }

    public String getName() {
        return this.cfg.getName();
    }

    public RepositoryStatus getStatus() {
        return this.cfg.getStatus();
    }

    public final void start() throws IOException, DbException {
        this.startEngine();
        this.datasetProducer = new LineCountDatasetProducer(this);
        this.datasetProducer.clear();
        this.dtcache = new DirTreeCache(this);
        this.getRevisionCache().addListener(new RevisionCache.CacheListener(){

            public void cacheUpdated() {
                RepositoryEngine.this.onCacheUpdated();
            }
        });
        WARMER.sendMessage(this.getName());
        Logs.APP_LOG.debug((Object)("Started engine " + this.getName()));
    }

    void softPassivate() {
        try {
            this.getLuceneConnection().close();
            this.getRevisionCache().getInfDb().close();
        }
        catch (Throwable e2) {
            Logs.APP_LOG.warn((Object)"problem passivating repository", e2);
        }
    }

    void setInfDbCacheSize(long size) {
        InfinityDbHandle infDb;
        this.infDbCacheSize = size;
        RevisionCache cache = this.getRevisionCache();
        if (cache != null && (infDb = cache.getInfDb()) != null) {
            infDb.setCacheSize(size);
        }
    }

    protected long getInfDbCacheSize() {
        return this.infDbCacheSize;
    }

    public static void deleteCache(RepositoryConfig cfg) {
        IOHelper.recursiveDelete(RepositoryEngine.cacheDir(cfg), 2);
    }

    private static File cacheDir(RepositoryConfig cfg) {
        return new File(AppConfig.getVarDir(), "cache/" + cfg.getName());
    }

    protected static void checkIsDir(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("could not create directory: " + dir.getAbsolutePath());
        }
    }

    public DirTreeCache getDirTreeCache() {
        return this.dtcache;
    }

    private void onCacheUpdated() {
        if (this.getStatus().isStopRequested()) {
            return;
        }
        this.dtcache.invalidate();
        WARMER.sendMessage(this.getName());
        this.eventMulticaster.fireRepositoryUpdate(this.getName());
    }

    public BucketGraph getBucketGraph() throws DbException {
        if (this.bucketGraph == null) {
            this.bucketGraph = new BucketGraph(this.getRevisionCache().getInfDb(), this.getName(), this.getRevisionCache().isCaseSensitive());
        }
        return this.bucketGraph;
    }

    public abstract void startEngine() throws IOException, DbException;

    public abstract SearchManager getSearchManager();

    public abstract LuceneConnection getLuceneConnection();

    public abstract RevisionCache getRevisionCache();

    protected abstract BaseRevisionCache getBaseRevisionCache();

    public abstract void forceClose();

    public abstract void requestFullscan();

    public abstract void doSlurp() throws DbException, ConfigException;

    protected abstract long getPollPeriod();

    protected abstract boolean wantInitialSlurp();

    public abstract void rescan(String var1, String var2) throws UnsupportedOperationException, IllegalStateException, RepositoryClientException, DbException;

    public void requestStop() {
    }

    public void doReviewSlurp(boolean reindex) throws DbException {
        CommonRevInfoDAO cdao = this.getBaseRevisionCache().getCommonRevInfoDAO();
        ReviewInfoDAO dao = new ReviewInfoDAO(this.getRevisionCache().getInfDb(), cdao, this.getName(), this.getStatus());
        boolean updated = dao.slurp(reindex);
        if (updated) {
            this.getBaseRevisionCache().touchLastModifiedDate();
        }
    }

    public void doLinecountReindex() throws DbException {
        this.getBucketGraph().reloadFromRevisionCache(this.getRevisionCache(), this.getStatus());
    }

    static {
        Thread t = new Thread((Runnable)WARMER, "FE-CacheWarmer");
        t.setDaemon(true);
        t.start();
    }
}

