/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.IOException;
import java.util.Locale;

public class UpgradeDataFilenameSearch {
    private final String repname;
    private final RepositoryStatus status;
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private boolean caseSensitive;

    public UpgradeDataFilenameSearch(String repname, RepositoryStatus status, InfinityDbHandle dbh, CommonStringTables stringTables, boolean caseSensitive) {
        this.repname = repname;
        this.status = status;
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.caseSensitive = caseSensitive;
    }

    public void upgradeIfNecessary() throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            cu.clear().append(CommonSchema.E_LCFILENAMEID_TO_REVID);
            int pl = cu.length();
            if (db.next(cu, pl)) {
                return;
            }
            Logs.CONSOLE.info((Object)("upgrading quicksearch data of repository " + this.repname));
            this.upgrade(db);
            db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void initAndUpgradeBuckets(RevisionCache cache) throws DbException {
        String serverTimezone;
        String dbTimezone;
        BucketGraph bucketGraph = new BucketGraph(this.dbh, this.repname, this.caseSensitive);
        if (!bucketGraph.isAtCurrentVersion()) {
            Logs.APP_LOG.debug((Object)("Repository " + this.repname + ": Started upgrading linecount database"));
            bucketGraph.reloadFromRevisionCache(cache, this.status);
            Logs.APP_LOG.debug((Object)("Repository " + this.repname + ": Finished upgrading linecount database"));
        }
        if (!(dbTimezone = bucketGraph.loadTimeZone()).equals(serverTimezone = AppConfig.getsConfig().getTimezone().getID())) {
            Logs.CONSOLE.info((Object)("Repository " + this.repname + ": Linecount database is calculated in " + dbTimezone + " time, " + "while the default timezone of the server is " + serverTimezone + ".  " + "When it is next recalculated the linecount database will use the server's timezone."));
        }
    }

    private void upgrade(_k4ui8vIDB db) throws IOException, DbException {
        this.status.setMessage("Upgrading quicksearch cache...");
        Logs.APP_LOG.info((Object)("Repository " + this.repname + ": Upgrading filename search data..."));
        long t0 = System.currentTimeMillis();
        _EntityItemSpace revs = new _EntityItemSpace(db, _Cu.alloc(CommonSchema.RevInfo.ENTITY));
        _Cu cu = _Cu.alloc();
        _Cu row = _Cu.alloc();
        _Cu newrow = _Cu.alloc();
        while (revs.next(cu)) {
            long pathid;
            String path;
            int revid = (int)cu.longAt(0);
            row.clear();
            row.append(CommonSchema.RevInfo.ENTITY).append(revid).append(CommonSchema.RevInfo.A_REVKEY);
            int pl = row.length();
            if (!db.next(row, pl) || (path = UniqueStringTable.get(db, CommonSchema.E_PATHS, pathid = row.longAt(pl))) == null) continue;
            String lcfilename = Path.parseName(path).toLowerCase(Locale.US);
            long lcfilenameid = this.stringTables.lcfilenameDB.add(lcfilename);
            newrow.clear();
            newrow.append(CommonSchema.E_LCFILENAMEID_TO_REVID).append(lcfilenameid).append(revid);
            db.insert(newrow);
        }
        long t1 = System.currentTimeMillis();
        Logs.APP_LOG.info((Object)("Repository " + this.repname + ": Upgraded filename search data in " + (t1 - t0) + "ms"));
    }
}

