/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryCache;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnContentProvider;
import com.cenqua.fisheye.svn.SvnFileHistory;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnQueryHelper;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.db.SvnStringTables;
import com.cenqua.fisheye.svn.lucene.SvnRecentChangesSearcher;
import com.cenqua.fisheye.util.SortedMultiMap;
import gnu.trove.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnCache
extends RepositoryCache
implements SvnContentProvider {
    private SvnStringTables svnStringTables;
    private final SvnRepositoryInfo repositoryInfo;
    private GenericObjectPool clientPool;
    private Pattern charsetRegex = Pattern.compile(".*;\\s*charset\\s*=\\s*\"?([^;\"]*)");

    public SvnCache(SvnRepositoryInfo repInfo) {
        this.repositoryInfo = repInfo;
    }

    public void setClientFactory(SvnClientFactory clientFactory) {
        this.clientPool = new GenericObjectPool((PoolableObjectFactory)clientFactory);
        this.clientPool.setMaxActive(50);
        this.clientPool.setMaxIdle(3);
        this.clientPool.setWhenExhaustedAction((byte)1);
        this.clientPool.setMaxWait(20000L);
    }

    public SvnThrottledClient allocateClient() throws DbException {
        try {
            return (SvnThrottledClient)this.clientPool.borrowObject();
        }
        catch (Exception e2) {
            throw new DbException("Unable to allocate an SVN client for " + this.repositoryInfo.getRepositoryDescriptor(), e2);
        }
    }

    public void returnClient(SvnThrottledClient client) {
        if (client != null) {
            try {
                this.clientPool.returnObject((Object)client);
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Exception returning client instance", (Throwable)e2);
            }
        }
    }

    public SvnRevInfoDAO createDAO() throws DbException {
        return new SvnRevInfoDAO(this.getInfDb(), this.svnStringTables, this.getCommonStringTables(), this.repositoryInfo.getPathMatcher());
    }

    @Override
    public void start() throws IOException, DbException {
        super.start();
        this.svnStringTables = new SvnStringTables(this.getInfDb());
    }

    @Override
    public FileRevision getFileRevision(int revid) throws DbException {
        return this.createDAO().loadRevision(revid);
    }

    @Override
    public FileRevision getFileRevision(RevInfoKey rkey) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        Path path = rkey.getPath();
        int revid = svnDAO.getRevId(path, Long.parseLong(rkey.getRev()));
        SvnRevInfo revInfo = null;
        if (revid != -1) {
            revInfo = svnDAO.loadRevision(revid);
            String container = this.repositoryInfo.getPathMatcher().getContainerId(path);
            if (container.startsWith("tag:") && !revInfo.getPath().equals(path)) {
                Path tagRoot = this.repositoryInfo.getPathMatcher().getTagRoot(path);
                int tagRootRevid = svnDAO.getRevId(tagRoot, Long.parseLong(rkey.getRev()));
                SvnRevInfo tagRev = svnDAO.loadRevision(tagRootRevid);
                revInfo.setSVNRevision(tagRev.getSvnRevision());
            }
        }
        return revInfo;
    }

    @Override
    public ChangeSet getChangeSet(String csid) throws DbException {
        long rev;
        SvnRevInfoDAO svnDAO = this.createDAO();
        try {
            rev = Long.parseLong(csid);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        return svnDAO.loadChangeSet(rev);
    }

    @Override
    public String getChangeSetId(RevInfoKey rk) {
        return rk.getRev();
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        Path[] pathArray;
        Path tagRoot = this.repositoryInfo.getPathMatcher().getTagRoot(dir);
        if (tagRoot == null) {
            pathArray = super.listFiles(dir);
        } else {
            SvnRevInfoDAO svnDAO = this.createDAO();
            String tag = this.repositoryInfo.getPathMatcher().getTag(dir);
            Path logicalDir = this.repositoryInfo.getPathMatcher().getLogicalPath(dir);
            pathArray = this.getTaggedPaths(svnDAO, logicalDir, 1, tag, tagRoot);
        }
        return pathArray;
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        Path[] pathArray;
        Path tagRoot = this.repositoryInfo.getPathMatcher().getTagRoot(dir);
        if (tagRoot == null) {
            pathArray = super.listDirs(dir);
        } else {
            SvnRevInfoDAO svnDAO = this.createDAO();
            String tag = this.repositoryInfo.getPathMatcher().getTag(dir);
            Path logicalDir = this.repositoryInfo.getPathMatcher().getLogicalPath(dir);
            pathArray = this.getTaggedPaths(svnDAO, logicalDir, 2, tag, tagRoot);
        }
        return pathArray;
    }

    private Path[] getTaggedPaths(SvnRevInfoDAO svnDAO, Path logicalDir, int fileType, String tag, Path tagRoot) throws DbException {
        List<Integer> revids = svnDAO.getTaggedDirEntries(logicalDir, fileType, tag, -1L);
        HashSet<Path> pathSet = new HashSet<Path>();
        for (Integer revid : revids) {
            RevInfoKey key = svnDAO.getKey(revid);
            Path relativePath = this.repositoryInfo.getPathMatcher().getLogicalTail(key.getPath());
            pathSet.add(new Path(tagRoot, relativePath.getPath()));
        }
        return pathSet.toArray(new Path[pathSet.size()]);
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        String tag = this.repositoryInfo.getPathMatcher().getTag(path);
        if (tag == null) {
            return this.getPathFileType(path) == 1;
        }
        return this.getTaggedFileType(path, tag) == 1;
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        if (path.isRoot()) {
            return true;
        }
        String tag = this.repositoryInfo.getPathMatcher().getTag(path);
        if (tag == null) {
            return this.getPathFileType(path) == 2;
        }
        return this.getTaggedFileType(path, tag) == 2;
    }

    @Override
    public RevInfoKey getKey(int revid) throws DbException {
        return this.createDAO().getKey(revid);
    }

    private int getTaggedFileType(Path physicalPath, String tag) throws DbException {
        Path logicalPath;
        SvnRevInfoDAO svnDAO = this.createDAO();
        int revid = svnDAO.getTaggedPathRevid(logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(physicalPath), tag, -1L);
        if (revid == -1) {
            return -1;
        }
        return svnDAO.getFileType(revid);
    }

    private int getPathFileType(Path path) throws DbException {
        long csid;
        SvnRevInfoDAO svnDAO = this.createDAO();
        int revid = svnDAO.getRevId(path, csid = svnDAO.getLatestPathChange(path));
        if (revid == -1) {
            return -1;
        }
        return svnDAO.getFileType(revid);
    }

    public SvnRevInfo getLatestRevision(Path physicalPath) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        long csid = svnDAO.getLatestPathChange(physicalPath);
        int revid = svnDAO.getRevId(physicalPath, csid);
        return (SvnRevInfo)this.getFileRevision(revid);
    }

    @Override
    public FileRevision getLatestFileRevision(Path path) throws DbException {
        return this.getLatestRevision(path);
    }

    @Override
    public FileHistory getFileHistory(Path physicalPath, boolean physicalOnly) throws DbException {
        SortedMultiMap csids;
        SvnRevInfoDAO svnDAO = this.createDAO();
        Path logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(physicalPath);
        String tag = this.repositoryInfo.getPathMatcher().getTag(physicalPath);
        if (physicalOnly || logicalPath == null) {
            csids = new SortedMultiMap();
            csids.addAll(svnDAO.getPathRevisions(physicalPath));
        } else {
            csids = svnDAO.getLogicalPathRevisions(logicalPath);
        }
        SortedMultiMap<Long, SvnRevInfo> history = new SortedMultiMap<Long, SvnRevInfo>();
        for (Long csid : csids.keySet()) {
            List revids = csids.getList(csid);
            for (Integer revid : revids) {
                SvnRevInfo revision = svnDAO.loadRevision(revid);
                if (logicalPath != null && !logicalPath.equals(revision.getLogicalPath())) {
                    Logs.APP_LOG.debug((Object)"Skipping revision as logical path did not match");
                    continue;
                }
                boolean includeRevision = tag == null || revision.getTags().contains(tag);
                if (!includeRevision) continue;
                history.add(csid, revision);
            }
        }
        return new SvnFileHistory(this, physicalPath, history);
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        SortedMultiMap ancestry = new SortedMultiMap();
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        Path logicalPath = pathMatcher.getLogicalPath(path);
        String containerId = pathMatcher.getContainerId(path);
        boolean useLogical = !physicalOnly || containerId.startsWith("tag:");
        long latestCsid = useLogical && logicalPath != null ? svnDAO.getLatestLogicalPathChange(logicalPath) : svnDAO.getLatestPathChange(path);
        RevInfoKey key = new RevInfoKey(path, Long.toString(latestCsid));
        SortedMapFileHistory.addFileAncestry(this, ancestry, key, true, !useLogical);
        return new SvnFileHistory(this, path, ancestry);
    }

    @Override
    public List<String> findRecentChangeSetIds(RecentChangesParams params) throws DbException {
        try {
            SvnRevInfoDAO svnDAO = this.createDAO();
            SvnRecentChangesSearcher rcSearcher = new SvnRecentChangesSearcher(svnDAO, this.getInfDb().get(), this.getLuceneConnection(), params, this.findDirInfo(params.getPath()), this.isCaseSensitive());
            return rcSearcher.findRecentChangeSets();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public List<ChangeSet> findRecentChangeSets(RecentChangesParams params) throws DbException {
        List<String> ids = this.findRecentChangeSetIds(params);
        ArrayList<ChangeSet> results = new ArrayList<ChangeSet>();
        for (String id : ids) {
            ChangeSet cs = this.getChangeSet(id);
            if (cs == null) continue;
            results.add(cs);
        }
        return results;
    }

    public void getTextRevision(RevInfoKey key, OutputStream aOut, String kopt) throws IOException, DbException {
        this.getTextRevision(key, aOut, kopt, null);
    }

    @Override
    public void getTextRevision(RevInfoKey key, OutputStream aOut, String kopt, String symrev) throws IOException, DbException {
        this.getBinaryRevision(key, aOut);
    }

    public Charset getMimeTypeCharset(String mimeType) {
        Matcher m;
        if (mimeType != null && (m = this.charsetRegex.matcher(mimeType.toLowerCase())).lookingAt()) {
            String charset = m.group(1);
            try {
                return Charset.forName(charset);
            }
            catch (UnsupportedCharsetException e2) {
                Logs.APP_LOG.error((Object)("Charset from " + mimeType + " is not supported."));
            }
        }
        return this.repositoryInfo.getDefaultCharset();
    }

    @Override
    public Charset getTextEncoding(RevInfoKey rkey) throws DbException {
        try {
            SvnRevInfoDAO dao = this.createDAO();
            int revid = dao.getRevId(rkey.getPath(), Long.parseLong(rkey.getRev()));
            String mimeType = dao.getSvnProperty(revid, "svn:mime-type");
            return this.getMimeTypeCharset(mimeType);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Exception accessing mime-type of " + rkey.getPath()), (Throwable)e2);
            throw new DbException(e2);
        }
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, OutputStream outputStream) throws IOException, DbException {
        block11: {
            int revid;
            long revision = Long.parseLong(key.getRev());
            SvnRevInfoDAO dao = this.createDAO();
            if (dao.isDeleted(revid = dao.getRevId(key.getPath(), Long.parseLong(key.getRev())))) {
                return;
            }
            Revision.Number rev = new Revision.Number(revision);
            SvnThrottledClient client = null;
            try {
                client = this.allocateClient();
                String contentURL = this.getContentURL(client, key.getPath(), revision);
                if (contentURL == null) {
                    Logs.APP_LOG.warn((Object)("Unable to access revision content for " + key + " as it is not accessible"));
                    break block11;
                }
                try {
                    Info2[] info = client.info2(contentURL, (Revision)rev, (Revision)rev, false);
                    if (info == null || info.length == 0 || info[0].getKind() != 1) {
                        return;
                    }
                }
                catch (RepositoryClientException e2) {
                    contentURL = this.repositoryInfo.getPathURL(key.getPath(), revision);
                }
                byte[] content = client.fileContent(contentURL, (Revision)rev, (Revision)rev);
                outputStream.write(content);
            }
            catch (RepositoryClientException e3) {
                Logs.APP_LOG.error((Object)("Exception loading SVN content for " + key), (Throwable)e3);
                throw new DbException("SVN Client exception fetching content: " + e3.getMessage(), e3);
            }
            finally {
                this.returnClient(client);
            }
        }
    }

    @Override
    public Blame getBlame(RevInfoKey revInfoKey) throws DbException, IOException {
        if (!this.getFileHistory(revInfoKey.getPath()).getRevision(revInfoKey.getRev()).isAnnotatable()) {
            throw new PathNotFoundException("File is not annotatable", revInfoKey);
        }
        SvnThrottledClient client = null;
        try {
            client = this.allocateClient();
            long rev = Long.parseLong(revInfoKey.getRev());
            Revision.Number endRev = new Revision.Number(rev);
            RevInfoKey contentKey = this.getContentRevInfoKey(client, revInfoKey.getPath(), rev);
            if (contentKey == null) {
                throw new PathNotFoundException("File is not annotatable", revInfoKey);
            }
            if (this.getFileRevision(contentKey) == null) {
                Logs.APP_LOG.warn((Object)"Unable to resolve content URL - may be a symbolic link outside repo");
                contentKey = revInfoKey;
            }
            List<Blame.BlameChunk> chunks = this.getBlameChunks(client, rev, (Revision)endRev, contentKey);
            Blame blame = new Blame(chunks);
            return blame;
        }
        catch (RepositoryClientException e2) {
            IOException ioe = new IOException("Exception getting SVN blame for " + revInfoKey + ": " + e2.getMessage());
            ioe.initCause(e2);
            throw ioe;
        }
        finally {
            this.returnClient(client);
        }
    }

    private List<Blame.BlameChunk> getBlameChunks(SvnThrottledClient client, long rev, Revision endRev, RevInfoKey contentKey) throws DbException, RepositoryClientException {
        Path path = contentKey.getPath();
        final int totalLines = this.getFileRevision(contentKey).getLineCount();
        final ArrayList<Blame.BlameChunk> chunks = new ArrayList<Blame.BlameChunk>();
        final SortedMultiMap fileAncestry = new SortedMultiMap();
        SortedMapFileHistory.addFileAncestry(this, fileAncestry, contentKey, true, true);
        String pathURL = this.repositoryInfo.getPathURL(path, rev);
        Iterator revs = fileAncestry.iterator();
        final FileRevision firstRev = revs.hasNext() ? (FileRevision)revs.next() : null;
        if (pathURL == null) {
            Logs.APP_LOG.warn((Object)("Unable to annotate " + path + "@" + rev + " as the content is not accessible"));
        } else {
            BlameCallback callback = new BlameCallback(){
                private int lineNum = 0;
                long currentRev = -1L;
                Blame.BlameChunk currentChunk = null;

                public void singleLine(Date date, long revision, String author, String line) {
                    if (this.lineNum >= totalLines) {
                        return;
                    }
                    if (this.currentRev == revision && this.currentChunk.getLength() < 8000) {
                        this.currentChunk.incLength(1);
                    } else {
                        FileRevision fileRev;
                        List revList = fileAncestry.getList(revision);
                        if (revList != null) {
                            fileRev = (FileRevision)revList.get(0);
                        } else {
                            SvnRevInfo placeHolder = new SvnRevInfo();
                            placeHolder.setRevision(Long.toString(revision));
                            if (firstRev != null) {
                                placeHolder.setDate(firstRev.getDate());
                            }
                            fileRev = placeHolder;
                        }
                        this.currentRev = revision;
                        this.currentChunk = new Blame.BlameChunk(fileRev, this.lineNum, this.lineNum);
                        chunks.add(this.currentChunk);
                    }
                    ++this.lineNum;
                }
            };
            client.blame(pathURL, endRev, Revision.START, endRev, callback);
        }
        return chunks;
    }

    @Override
    public List<String> getSimilarChangeSetIds(String id) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialId) throws DbException {
        return Collections.emptyList();
    }

    public SvnLogicalPathMatcher getPathMatcher() {
        return this.repositoryInfo.getPathMatcher();
    }

    @Override
    public String getImpliedBranch(Path physicalPath) {
        return this.repositoryInfo.getPathMatcher().getBranch(physicalPath);
    }

    @Override
    public AndQuery3 findRevisionsUnderDirQuery3(Path dir, boolean findLogical) {
        Path logicalPath;
        if (findLogical && (logicalPath = this.getPathMatcher().getLogicalPath(dir)) != null) {
            return SvnQueryHelper.findRevisionsUnderLogicalDir3(logicalPath);
        }
        return CommonQuery3Helper.findRevisionsUnderDirQuery3(dir, this.isCaseSensitive());
    }

    public RevInfoKey getContentRevInfoKey(SvnThrottledClient client, Path path, long revnum) throws RepositoryClientException, DbException {
        String svnSpecial;
        SvnRevInfoDAO svnDAO = this.createDAO();
        long activeRev = svnDAO.getLatestPathChangeUpto(path, revnum);
        if (activeRev == -1L) {
            activeRev = revnum;
        }
        if ((svnSpecial = this.getSvnSpecialValue(client, path, svnDAO, activeRev)) == null) {
            return new RevInfoKey(path, Long.toString(activeRev));
        }
        Path resolvedPath = path;
        boolean followingLink = true;
        try {
            while (followingLink) {
                Revision.Number rev = new Revision.Number(revnum);
                byte[] content = client.fileContent(this.repositoryInfo.getPathURL(resolvedPath, revnum), (Revision)rev, (Revision)rev);
                String link = new String(content, "UTF-8");
                if (link.startsWith("link ")) {
                    String linkInfo = link.substring("link ".length());
                    activeRev = svnDAO.getLatestPathChangeUpto(resolvedPath = new Path(resolvedPath.getParent(), linkInfo).normalize(), revnum);
                    if (activeRev == -1L) {
                        activeRev = revnum;
                    }
                    if ((svnSpecial = this.getSvnSpecialValue(client, resolvedPath, svnDAO, activeRev)) != null) continue;
                    followingLink = false;
                    continue;
                }
                break;
            }
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        if (resolvedPath == null) {
            activeRev = svnDAO.getLatestPathChangeUpto(path, revnum);
            resolvedPath = path;
        }
        return new RevInfoKey(resolvedPath, Long.toString(activeRev));
    }

    private String getSvnSpecialValue(SvnThrottledClient client, Path path, SvnRevInfoDAO svnDAO, long activeRev) throws DbException {
        String svnSpecial = null;
        int revid = svnDAO.getRevId(path, activeRev);
        if (revid == -1) {
            Revision.Number rev = new Revision.Number(activeRev);
            try {
                PropertyData pd = client.propertyGet(this.repositoryInfo.getPathURL(path, activeRev), "svn:special", (Revision)rev, (Revision)rev);
                if (pd != null) {
                    svnSpecial = pd.getValue();
                }
            }
            catch (RepositoryClientException e2) {}
        } else {
            svnSpecial = svnDAO.getSvnProperty(revid, "svn:special");
        }
        return svnSpecial;
    }

    public String getContentURL(SvnThrottledClient client, Path path, long rev) throws RepositoryClientException, DbException {
        RevInfoKey resolvedKey = this.getContentRevInfoKey(client, path, rev);
        if (resolvedKey == null) {
            return null;
        }
        return this.repositoryInfo.getPathURL(resolvedKey.getPath(), rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportContent(Path physicalPath, File contentFile, long revision) throws IOException, DbException, RepositoryClientException {
        SvnThrottledClient client = null;
        boolean contentExported = false;
        try {
            Revision.Number rev = new Revision.Number(revision);
            client = this.allocateClient();
            String url = this.getContentURL(client, physicalPath, revision);
            if (url == null) {
                Logs.APP_LOG.warn((Object)("Unable to export content as the content for " + physicalPath + "@" + rev + " is not accessible"));
            } else {
                try {
                    Info2[] info = client.info2(url, (Revision)rev, (Revision)rev, false);
                    if (info.length != 1 || info[0].getKind() != 1) {
                        Logs.APP_LOG.error((Object)("Not exporting content for " + url + " as it is a directory."));
                    } else {
                        client.doExport(url, contentFile.getAbsolutePath(), (Revision)rev, (Revision)rev, true, true, false, "LF");
                        contentExported = true;
                    }
                }
                catch (RepositoryClientException e2) {
                    Logs.APP_LOG.warn((Object)("Unable to export content from " + url + " for " + physicalPath + "@" + revision));
                }
            }
            this.returnClient(client);
        }
        catch (Throwable throwable) {
            this.returnClient(client);
            throw throwable;
        }
        return contentExported;
    }

    public SvnRevInfo getLatestRevisionUpto(Path path, long revision) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        long csid = svnDAO.getLatestPathChangeUpto(path, revision);
        int revid = svnDAO.getRevId(path, csid);
        return svnDAO.loadRevision(revid);
    }

    public SvnRepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() throws DbException {
        return this.createDAO().getCommonRevInfoDAO();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.repositoryInfo.isCaseSensitive();
    }

    @Override
    public boolean showAuthorLinecount() {
        return this.repositoryInfo.isStoreDiffs();
    }

    public String getSVNProperty(RevInfoKey rkey, String propertyName) throws DbException {
        try {
            SvnRevInfoDAO dao = this.createDAO();
            int revid = dao.getRevId(rkey.getPath(), Long.parseLong(rkey.getRev()));
            return dao.getSvnProperty(revid, propertyName);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Exception accessing property " + propertyName + " of " + rkey.getPath()), (Throwable)e2);
            throw new DbException(e2);
        }
    }

    @Override
    public String getRepositoryType() {
        return "svn";
    }

    public TLongHashSet getChangesets(long start, long end) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        return svnDAO.getChangeSets(start, end);
    }

    public void updateRevisionComment(RevInfoKey key, String comment) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        svnDAO.updateComment(key, comment);
    }

    public void updateRevisionAuthor(RevInfoKey key, String author) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        svnDAO.updateAuthor(key, author);
    }

    public void updateRevisionDate(RevInfoKey key, long date) throws DbException {
        SvnRevInfoDAO svnDAO = this.createDAO();
        svnDAO.updateDate(key, date);
    }

    public void updateRevisionProperty(long csid, String name, String value) throws DbException {
        SvnRevInfoDAO dao = this.createDAO();
        dao.updateRevProp(csid, name, value);
    }

    public void removePurgedRevProps(long csid, Set retainSet) throws DbException {
        SvnRevInfoDAO dao = this.createDAO();
        Map<String, String> currentProps = dao.getRevProps(csid);
        currentProps.keySet().removeAll(retainSet);
        dao.removeRevProps(csid, currentProps.keySet());
    }

    @Override
    public DirInfo findDirInfo(Path lpath) throws DbException {
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        String containerId = pathMatcher.getContainerId(lpath);
        if (containerId.startsWith("tag:")) {
            SvnRevInfoDAO dao = this.createDAO();
            int taggedRevid = dao.getRevId(lpath, -1L);
            RevInfoKey key = dao.getKey(taggedRevid);
            return super.findDirInfo(key.getPath());
        }
        return super.findDirInfo(lpath);
    }
}

