/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.SvnMessageIterator;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.MessageInfo;
import com.cenqua.fisheye.svn.util.ChangePathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.PropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnMessageContext {
    private final SvnRepositoryInfo repositoryInfo;
    private final LogMessage message;
    private final MessageInfo messageInfo;
    private final SvnMessageIterator processingIterator;
    private Map<String, String> revProps;
    private String author;
    private String comment;
    private long date = -1L;

    public SvnMessageContext(SvnRepositoryInfo repositoryInfo, LogMessage message, MessageInfo messageInfo) {
        this.repositoryInfo = repositoryInfo;
        this.message = message;
        this.messageInfo = messageInfo;
        this.processingIterator = this.iterator();
        this.author = message.getAuthor();
        this.comment = message.getMessage();
        if (message.getDate() != null) {
            this.date = message.getDate().getTime();
        }
        if (messageInfo != null) {
            this.filterRevProps(messageInfo.getRevProps());
        }
    }

    private void filterRevProps(PropertyData[] revPropData) {
        this.revProps = new HashMap<String, String>();
        if (revPropData != null) {
            for (PropertyData revProp : revPropData) {
                String name = revProp.getName();
                if (name.equals("svn:log") || name.equals("svn:author") || name.equals("svn:date")) continue;
                this.revProps.put(name, revProp.getValue());
            }
        }
    }

    private SvnMessageIterator iterator() {
        return new SvnMessageIterator(this.message.getChangedPaths());
    }

    public long getRevision() {
        return this.message.getRevisionNumber();
    }

    public String getAuthor() {
        if (this.author == null) {
            Logs.APP_LOG.info((Object)("Revision " + this.message.getRevisionNumber() + " in repository " + this.repositoryInfo.getRepositoryName() + " has no author defined"));
            this.author = "no_author";
        }
        return this.author;
    }

    public long getDate() {
        if (this.date == -1L) {
            Logs.APP_LOG.info((Object)("Revision " + this.message.getRevisionNumber() + " in repository " + this.repositoryInfo.getRepositoryName() + " has no date - using epoch date"));
            this.date = 0L;
        }
        return this.date;
    }

    public String getMessage() {
        if (this.comment == null) {
            Logs.APP_LOG.info((Object)("Revision " + this.message.getRevisionNumber() + " in repository " + this.repositoryInfo.getRepositoryName() + " has no check-in comment"));
            this.comment = "";
        }
        return this.comment;
    }

    public ChangeInfo getChangeInfo(Path destPath) {
        return this.messageInfo.getChangeInfo(destPath);
    }

    public boolean hasMessageInfo() {
        return this.messageInfo != null;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public boolean hasChangePaths() {
        return this.message.getChangedPaths() != null;
    }

    public SvnMessageIterator getPathIterator() {
        return this.processingIterator;
    }

    public boolean isCurrentPathCopy() {
        return this.getCurrentPath().getCopySrcPath() != null;
    }

    public boolean isPathMoved(String serverPath) {
        ChangePath deletingChange = null;
        ChangePath addingSourceChange = null;
        SvnMessageIterator i2 = this.iterator();
        while (i2.hasNext()) {
            boolean moreSpecific;
            ChangePath changePath = (ChangePath)i2.next();
            char action = changePath.getAction();
            if (ChangePathUtil.isSubPath(changePath.getPath(), serverPath)) {
                boolean deleteAction = action == 'D' || action == 'R';
                boolean bl = moreSpecific = deletingChange == null || changePath.getPath().length() > deletingChange.getPath().length();
                if (deleteAction && moreSpecific) {
                    deletingChange = changePath;
                } else if (!deleteAction && moreSpecific) {
                    deletingChange = null;
                }
            }
            if (changePath.getCopySrcPath() == null || !ChangePathUtil.isSubPath(changePath.getCopySrcPath(), serverPath)) continue;
            boolean addAction = action == 'A' || action == 'R';
            boolean bl = moreSpecific = addingSourceChange == null || changePath.getPath().length() > addingSourceChange.getPath().length();
            if (addAction && moreSpecific) {
                addingSourceChange = changePath;
                continue;
            }
            if (action != 'D' || !moreSpecific) continue;
            addingSourceChange = null;
        }
        return deletingChange != null && addingSourceChange != null;
    }

    public List<ChangePath> getApplicableChangePaths(Path physicalPath) {
        String serverPath = this.repositoryInfo.getServerPath(physicalPath, this.getRevision());
        return ChangePathUtil.getApplicableChangePaths(this.message.getChangedPaths(), serverPath);
    }

    public ChangePath getMostSpecificChange(Path path) {
        return ChangePathUtil.getMostSpecific(this.getApplicableChangePaths(path));
    }

    public boolean isCurrentMostSpecific(Path path) {
        return this.getCurrentPath() == this.getMostSpecificChange(path);
    }

    public ChangePath getContainingCopy(Path path) {
        Path parent = path.getParent();
        while (!parent.isRoot()) {
            ChangePath specificPath = this.getMostSpecificChange(parent);
            if (specificPath != null && specificPath.getCopySrcPath() != null && specificPath != this.getCurrentPath()) {
                return specificPath;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public ChangePath getCurrentPath() {
        return this.processingIterator.current();
    }

    public Map<String, String> getRevProps() {
        return this.revProps;
    }
}

