/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryTester;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryEngine;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnRepositoryTester;
import com.cenqua.fisheye.svn.lucene.SvnConstants;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.StringUtil;
import java.nio.charset.Charset;

public class SvnRepositoryConfig
extends RepositoryConfig {
    private final String mUrl;
    private final String mRepoPath;
    private final SvnLogicalPathMatcher mPathMatcher;
    private final long blocksize;
    private final Charset defaultCharset;
    private final String accessKey;
    private final NetworkRepositorySettings networkSettings;
    private final long startRev;
    private String importMode = "none";
    private final String commandTimeout;

    public SvnRepositoryConfig(RepositoryType rcfg, RepositoryDefaultsType defaults) throws ConfigException {
        super(rcfg, defaults);
        SvnRepType svnE = rcfg.getSvn();
        if (svnE == null) {
            throw new ConfigException(this.getName() + " did not contain expected <svn>");
        }
        this.mUrl = svnE.getUrl();
        this.mRepoPath = svnE.getPath();
        this.blocksize = svnE.isSetBlocksize() ? svnE.getBlocksize().longValue() : 400L;
        if (svnE.isSetCharset()) {
            String cs = svnE.getCharset();
            try {
                this.defaultCharset = Charset.forName(cs);
            }
            catch (IllegalArgumentException e2) {
                throw new ConfigException("Not a valid encoding name: '" + cs + "'. Valid names are " + Charset.availableCharsets().keySet(), e2);
            }
        } else {
            this.defaultCharset = SvnConstants.DEFAULT_SVN_ENCODING;
        }
        this.accessKey = svnE.isSetAccess() ? svnE.getAccess() : null;
        if (svnE.isSetSymbolic()) {
            SvnSymbolicType symbolic = svnE.getSymbolic();
            this.mPathMatcher = new SvnLogicalPathMatcher(symbolic);
        } else {
            this.mPathMatcher = new SvnLogicalPathMatcher();
        }
        String pollPeriod = svnE.isSetUpdater() ? svnE.getUpdater().getPollPeriod() : null;
        UserPassAuthType auth = svnE.isSetAuth() ? svnE.getAuth() : null;
        float cpsLimit = svnE.isSetCps() ? svnE.getCps() : 0.0f;
        this.networkSettings = new NetworkRepositorySettings(auth, pollPeriod, cpsLimit);
        this.startRev = svnE.isSetStartRev() ? svnE.getStartRev().longValue() : 0L;
        if (svnE.isSetInitialImport()) {
            this.importMode = svnE.getInitialImport();
        }
        this.commandTimeout = svnE.isSetCommandTimeout() && !StringUtil.nullOrEmpty(svnE.getCommandTimeout().trim()) ? svnE.getCommandTimeout() : null;
    }

    public SvnRepositoryInfo createRepositoryInfo() {
        SvnRepositoryInfo repInfo = new SvnRepositoryInfo();
        repInfo.setAllowRules(this.getAllowRules());
        repInfo.setRepositoryName(this.getName());
        repInfo.setRepositoryLocation(this.getRepoUrl().trim(), this.getRepoPath());
        repInfo.setContentIndexingEnabled(this.isContentIndexingEnabled());
        repInfo.setPathMatcher(this.getPathMatcher());
        repInfo.setStartRev(this.getStartRev());
        repInfo.setImportMode(this.getImportMode());
        repInfo.setDefaultCharset(this.getDefaultCharset());
        repInfo.setStoreDiffs(this.isStoreDiffs());
        if (this.commandTimeout != null) {
            try {
                Interval commandTimeoutInterval = new Interval(this.commandTimeout);
                repInfo.setCommandTimeout(commandTimeoutInterval.getValueInMillis());
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.error((Object)("Command timeout interval is not valid: " + this.commandTimeout));
            }
        } else {
            repInfo.setCommandTimeout(3600000L);
        }
        return repInfo;
    }

    public RepositoryEngine createRepositoryEngine() throws ConfigException, DbException {
        SvnLoader.checkLoaded();
        return new SvnRepositoryEngine(this);
    }

    public RepositoryTester createRepositoryTester() {
        return new SvnRepositoryTester(this);
    }

    public NetworkRepositorySettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getRepoUrl() {
        return this.mUrl;
    }

    public String getRepoPath() {
        return this.mRepoPath;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public SvnLogicalPathMatcher getPathMatcher() {
        return this.mPathMatcher;
    }

    public long getBlocksize() {
        return this.blocksize;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public long getStartRev() {
        return this.startRev;
    }

    public String getImportMode() {
        return this.importMode;
    }
}

