/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryInfo;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.Revision;

public class SvnRepositoryInfo
extends RepositoryInfo {
    private String repositoryURL;
    private String repositoryBase;
    private boolean followBaseHistory = false;
    private SvnLogicalPathMatcher pathMatcher = new SvnLogicalPathMatcher();
    private Charset defaultCharset;
    private Locale locale = Locale.getDefault();
    private final SortedMap<Long, String> repositoryBaseHistory = new TreeMap<Long, String>();
    private boolean isCaseSensitive = true;

    public void setPathMatcher(SvnLogicalPathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public boolean isFollowBaseHistory() {
        return this.followBaseHistory;
    }

    public void setRepositoryLocation(String repositoryURL, String repositoryBase) {
        this.repositoryURL = SvnRepositoryInfo.normalizeURL(repositoryURL);
        this.repositoryBase = new Path(repositoryBase).normalize().getPath();
        this.repositoryBaseHistory.clear();
        this.repositoryBaseHistory.put(0L, repositoryBase);
    }

    public static String normalizeURL(String repositoryURL) {
        String normalized = repositoryURL.endsWith("/") ? repositoryURL.substring(0, repositoryURL.length() - 1) : repositoryURL;
        return normalized;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public String getRepositoryRoot(long rev) {
        return this.getRepositoryURL() + "/" + this.getRepositoryBase(rev);
    }

    public String getPathURL(Path path, long rev) {
        Path basePath = new Path(this.getRepositoryBase(rev));
        Path location = new Path(basePath, path);
        String urlPath = location.toURL();
        return this.repositoryURL + "/" + urlPath;
    }

    public Path getLocalPath(String serverPath, long rev) {
        return new Path(serverPath).getRelativePath(new Path(this.getRepositoryBase(rev)));
    }

    public String getRepositoryDescriptor() {
        Long last = this.repositoryBaseHistory.lastKey();
        return this.getRepositoryURL() + "/" + this.getRepositoryBase(last);
    }

    public String getServerPath(Path localPath, long rev) {
        Path basePath = new Path(this.getRepositoryBase(rev));
        return "/" + new Path(basePath, localPath).normalize().getPath();
    }

    public SvnLogicalPathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private String getRepositoryBase(long rev) {
        Long actualRev;
        if (rev == -1L) {
            actualRev = this.repositoryBaseHistory.lastKey();
        } else {
            SortedMap<Long, String> headMap = this.repositoryBaseHistory.headMap(rev + 1L);
            actualRev = headMap.lastKey();
        }
        return (String)this.repositoryBaseHistory.get(actualRev);
    }

    public void fillInRepositoryBasePathHistory(SvnThrottledClient svnClient) {
        boolean copied;
        if (!this.followBaseHistory) {
            return;
        }
        this.repositoryBaseHistory.clear();
        Revision rev = Revision.HEAD;
        String repositoryPath = this.repositoryBase;
        block2: do {
            Path location = new Path(repositoryPath);
            String urlPath = location.toURL();
            String url = this.repositoryURL + "/" + urlPath;
            copied = false;
            try {
                LogMessage[] messages = svnClient.logMessages(url, Revision.START, rev, true, true, 1L);
                for (ChangePath changePath : messages[0].getChangedPaths()) {
                    Path path = new Path(changePath.getPath());
                    if (!path.equals(location)) continue;
                    if (changePath.getCopySrcPath() == null) continue block2;
                    this.repositoryBaseHistory.put(messages[0].getRevisionNumber(), repositoryPath);
                    repositoryPath = changePath.getCopySrcPath();
                    rev = new Revision.Number(changePath.getCopySrcRevision());
                    copied = true;
                    continue block2;
                }
            }
            catch (RepositoryClientException e2) {
                // empty catch block
            }
        } while (copied);
        this.repositoryBaseHistory.put(0L, repositoryPath);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }
}

