/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.config1.HostauthConfigType;
import com.cenqua.fisheye.config1.LdapConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AJPAuth;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.CustomAuth;
import com.cenqua.fisheye.user.FEGroupEAV;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.FEUserEAV;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.LoginEAV;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserRenamer;
import com.cenqua.fisheye.user.crowd.CrowdAuth;
import com.cenqua.fisheye.user.ldap.LDAPAuth;
import com.cenqua.fisheye.user.os.HostAuth;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchEAV;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager {
    public static final String USER_ATTR_KEY = "feuser";
    private static final String LASTUSER_SESSION_KEY = UserManager.class.getName() + ".LAST_USER";
    public static final String REMEMBERME_COOKIE_NAME = "remember";
    private static final int REMEMBERME_COOKIE_AGE = 31536000;
    private static final Random RANDOM;
    private static final int NRANDOM_BYTES = 16;
    private final InfinityDbHandle mDB;
    private final Object mDbLock;
    private BaseAuth mAuth;
    private boolean mAutoImport = false;
    private Integer mUserCountCache = null;

    public UserManager(InfinityDbHandle DB, Object dblock, ConfigDocument.Config config) throws ConfigException, DbException {
        this.mDB = DB;
        this.mDbLock = dblock;
        this.upgradeData();
        this.reload(config);
    }

    public void notifyLicenseUpdate() {
        try {
            this.updateCrucibleUserCount();
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Failed to update Crucible user count from updated license", (Throwable)e2);
        }
    }

    private void upgradeData() throws DbException {
        this.updateCrucibleUserCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCrucibleUserCount() throws DbException {
        if (AppConfig.isCrucible()) {
            LicenseInfo license = AppConfig.getsConfig().getLicense();
            if (license != null) {
                Object object = this.mDbLock;
                synchronized (object) {
                    FEUserEAV eav = new FEUserEAV(this.mDB.get());
                    int max = license.getCrucibleLicense().isNumberOfUsersLimited() ? license.getCrucibleLicense().getMaxCrucibleUsers() : Integer.MAX_VALUE;
                    eav.updateInitialCrucibleUsers(max);
                }
            } else {
                Logs.APP_LOG.warn((Object)"No license info available, not updating Crucible user count.");
            }
        }
    }

    public void reload(ConfigDocument.Config config) throws ConfigException {
        SecurityType secCfg;
        if (this.mAuth != null) {
            this.mAuth.close();
            this.mAuth = null;
            this.mAutoImport = false;
        }
        if ((secCfg = config.getSecurity()).isSetLdap()) {
            LdapConfigType ldapCfg = secCfg.getLdap();
            this.mAuth = new LDAPAuth(ldapCfg);
            this.mAutoImport = this.mAuth.getAutoAdd();
        } else if (secCfg.isSetHostAuth()) {
            HostauthConfigType hostAuth = secCfg.getHostAuth();
            this.mAuth = new HostAuth(hostAuth);
            this.mAutoImport = this.mAuth.getAutoAdd();
        } else if (secCfg.isSetAjp()) {
            AjpAuthConfigType ajpAuth = secCfg.getAjp();
            this.mAuth = new AJPAuth(ajpAuth);
            this.mAutoImport = this.mAuth.getAutoAdd();
        } else if (secCfg.isSetCrowd()) {
            CrowdAuthConfigType crowdCfg = secCfg.getCrowd();
            this.mAuth = new CrowdAuth(crowdCfg);
            this.mAutoImport = this.mAuth.getAutoAdd();
        } else if (secCfg.isSetCustom()) {
            CustomSecurityConfigType custom = secCfg.getCustom();
            this.mAuth = new CustomAuth(custom);
            this.mAutoImport = this.mAuth.getAutoAdd();
        } else {
            this.mAuth = null;
            this.mAutoImport = false;
        }
    }

    public UserLogin validateCurrentUser(HttpServletRequest req, HttpServletResponse response) {
        BaseAuth.AuthTok authTok;
        UserLogin userLogin = this.getCurrentUser(req);
        if (userLogin != null && this.mAuth != null && userLogin.getAuthTok().getAuthType() != this.mAuth.getAuthType()) {
            return userLogin;
        }
        if (userLogin != null && this.mAuth != null && !this.mAuth.isRequestUserStillValid(userLogin, authTok = userLogin.getAuthTok(), req, response)) {
            try {
                this.clearLoginTokens(userLogin, req, response);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Problem logging user out", (Throwable)e2);
            }
            return null;
        }
        return userLogin;
    }

    public UserLogin getCurrentUser(HttpServletRequest req) {
        UserLogin user = (UserLogin)req.getAttribute(USER_ATTR_KEY);
        if (user != null) {
            return user;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            return null;
        }
        UserLogin userLogin = (UserLogin)session.getAttribute(USER_ATTR_KEY);
        return userLogin;
    }

    public UserLogin getCurrentUser(JspContext ctx) {
        UserLogin user = (UserLogin)ctx.getAttribute(USER_ATTR_KEY, 2);
        if (user != null) {
            return user;
        }
        try {
            user = (UserLogin)ctx.getAttribute(USER_ATTR_KEY, 3);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginCookie preCookUrl(HttpServletRequest req, String uri, boolean allowRecursive) throws DbException {
        LoginCookie lc;
        UserLogin user = this.getCurrentUser(req);
        if (user == null) {
            return null;
        }
        Object object = this.mDbLock;
        synchronized (object) {
            LoginEAV eav = new LoginEAV(this.mDB.get());
            lc = eav.addPreCookedUrlCookie(user.getUsername(), this.makePersistentLoginRnd(), uri, allowRecursive);
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserLogin login(HttpServletRequest req, HttpServletResponse resp, String username, String password, boolean rememberme) throws DbException, LicensePolicyException {
        BaseAuth.AuthTok authTok;
        if (password == null || "".equals(password)) {
            return null;
        }
        FEUser user = this.getOrImportUser(req, resp, username = this.sanitize(username), password);
        if (user == null) {
            return null;
        }
        if (user.getAuthType() == 1) {
            String expectedHash = user.getPasswordHash();
            if (expectedHash == null) {
                return null;
            }
            String hash = MD5.hash(password);
            if (!hash.equalsIgnoreCase(expectedHash)) {
                return null;
            }
            authTok = new BaseAuth.BuiltInAuthTok(user);
        } else {
            if (this.mAuth == null || this.mAuth.getAuthType() != user.getAuthType()) {
                Logs.APP_LOG.warn((Object)("cannot authenticate user " + username + " because user's auth type " + user.getAuthType() + " is not configured"));
                return null;
            }
            authTok = this.mAuth.checkPassword(username, password, req, resp);
            if (authTok == null) {
                return null;
            }
        }
        LoginCookie lc = null;
        if (rememberme) {
            Object object = this.mDbLock;
            synchronized (object) {
                LoginEAV eav = new LoginEAV(this.mDB.get());
                lc = eav.addRememberMeCookie(username, this.makePersistentLoginRnd());
            }
        }
        return this.doLogin(req, resp, user, authTok, lc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserLogin login(HttpServletRequest req, HttpServletResponse resp, LoginCookieToken given) throws DbException {
        BaseAuth.AuthTok auth;
        LoginCookie expected;
        if (given == null) {
            return null;
        }
        Object object = this.mDbLock;
        synchronized (object) {
            LoginEAV eav = new LoginEAV(this.mDB.get());
            expected = eav.findCookie(given.getUsername(), given.getLoginId());
            if (expected == null) {
                return null;
            }
            if (!expected.matches(given, req)) {
                Logs.APP_LOG.info((Object)("attempt to login using expired/invalid token " + given.getUsername() + " from " + req.getRemoteAddr() + " to URL " + req.getRequestURI()));
                return null;
            }
            if (expected.getType() == 1) {
                expected.setRnd(this.makePersistentLoginRnd());
                eav.updateCookie(expected);
            }
        }
        FEUser user = this.getUser(expected.getUsername());
        if (user == null) {
            return null;
        }
        if (user.getAuthType() == 1) {
            auth = new BaseAuth.BuiltInAuthTok(user);
        } else {
            if (this.mAuth == null || this.mAuth.getAuthType() != user.getAuthType()) {
                Logs.APP_LOG.warn((Object)("cannot authenticate user " + user.getUsername() + " because user's auth type " + user.getAuthType() + " is not configured"));
                return null;
            }
            auth = this.mAuth.recreateAuth(user.getUsername());
            if (auth == null) {
                Logs.APP_LOG.info((Object)("cannot re-authenticate user " + user.getUsername() + " they will need to login again"));
                return null;
            }
        }
        return this.doLogin(req, resp, user, auth, expected);
    }

    private FEUser getOrImportDelegatedUser(BaseAuth.AuthTok authTok) throws DbException, LicensePolicyException {
        FEUser user = this.getUser(authTok.getUsername());
        if (user == null && this.mAutoImport) {
            user = this.importUser(authTok);
        }
        return user;
    }

    private FEUser getOrImportUser(HttpServletRequest req, HttpServletResponse resp, String uname, String password) throws DbException, LicensePolicyException {
        BaseAuth.AuthTok authTok;
        FEUser user = this.getUser(uname = this.sanitize(uname));
        if (user == null && this.mAutoImport && (authTok = this.mAuth.checkPassword(uname, password, req, resp)) != null) {
            user = this.importUser(authTok);
        }
        return user;
    }

    private FEUser importUser(BaseAuth.AuthTok pAuthTok) throws DbException, LicensePolicyException {
        Logs.APP_LOG.info((Object)("auto-import user: " + pAuthTok.getUsername()));
        FEUser user = new FEUser(pAuthTok.getUsername());
        user.setEmail(pAuthTok.getEmail());
        user.setDisplayName(pAuthTok.getDisplayName());
        user.setAuthType(this.mAuth.getAuthType());
        this.addUserImpl(user, null);
        return user;
    }

    public UserLogin tryRequestDelegatedLogin(HttpServletRequest request, HttpServletResponse response) throws DbException, LicensePolicyException {
        if (this.mAuth == null) {
            return null;
        }
        BaseAuth.AuthTok authTok = this.mAuth.checkRequest(request, response);
        if (authTok == null) {
            return null;
        }
        FEUser feUser = this.getOrImportDelegatedUser(authTok);
        if (feUser == null) {
            return null;
        }
        if (this.mAuth.getAuthType() != feUser.getAuthType()) {
            Logs.APP_LOG.warn((Object)("cannot authenticate user " + feUser.getUsername() + " because user's auth type " + feUser.getAuthType() + " is not what is configured, " + this.mAuth.getAuthType()));
            return null;
        }
        UserLogin userLogin = new UserLogin(feUser, authTok, null);
        request.setAttribute(USER_ATTR_KEY, (Object)userLogin);
        PreferenceManager.touchCookie(request, response);
        HttpSession session = request.getSession(true);
        session.setAttribute(USER_ATTR_KEY, (Object)userLogin);
        return userLogin;
    }

    public UserLogin createTrustedUserLogin(String username, boolean forceExactMatch, boolean allowAutoAdd) throws LicensePolicyException, DbException {
        UserLogin trustedUserLogin = this.createTrustedUserLoginImpl(username, allowAutoAdd);
        if (!forceExactMatch && trustedUserLogin == null) {
            trustedUserLogin = this.createTrustedUserLoginImpl(this.sanitize(username), allowAutoAdd);
        }
        return trustedUserLogin;
    }

    public UserLogin createTrustedUserLogin(String username) throws DbException, LicensePolicyException {
        return this.createTrustedUserLogin(username, true, true);
    }

    private UserLogin createTrustedUserLoginImpl(String username, boolean allowAutoAdd) throws DbException, LicensePolicyException {
        FEUser user = this.getUser(username);
        if (user != null && user.getAuthType() == 1) {
            return new UserLogin(user, new BaseAuth.BuiltInAuthTok(user), null);
        }
        if (this.mAuth == null) {
            return null;
        }
        BaseAuth.AuthTok authTok = this.mAuth.recreateAuth(username);
        if (authTok == null) {
            return null;
        }
        if (user == null) {
            if (!allowAutoAdd) {
                return null;
            }
            user = this.getOrImportDelegatedUser(authTok);
        }
        return new UserLogin(user, authTok, null);
    }

    public void logout(HttpServletRequest req, HttpServletResponse resp) throws DbException {
        UserLogin login = this.getCurrentUser(req);
        this.clearLoginTokens(login, req, resp);
        if (login != null && this.mAuth != null) {
            this.mAuth.logout(login, req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLoginTokens(UserLogin login, HttpServletRequest req, HttpServletResponse resp) throws DbException {
        PreferenceManager.touchCookie(req, resp);
        Cookie c2 = UserManager.newRememberMeHttpCookie(req, "");
        c2.setMaxAge(0);
        resp.addCookie(c2);
        req.removeAttribute(USER_ATTR_KEY);
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.removeAttribute(USER_ATTR_KEY);
            if (login != null) {
                LastLogin lastLogin = new LastLogin(login.getUsername());
                session.setAttribute(LASTUSER_SESSION_KEY, (Object)lastLogin);
            }
        }
        if (login != null && login.getCookie() != null) {
            LoginCookie lc = login.getCookie();
            Object object = this.mDbLock;
            synchronized (object) {
                LoginEAV eav = new LoginEAV(this.mDB.get());
                eav.invalidateCookie(lc.getUsername(), lc.getLoginId());
            }
        }
    }

    public void logout2(HttpServletRequest req, HttpServletResponse resp, boolean clearRemember, boolean clearPrecooked) throws DbException {
        PreferenceManager.touchCookie(req, resp);
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        LastLogin lastLogin = (LastLogin)session.getAttribute(LASTUSER_SESSION_KEY);
        if (lastLogin == null) {
            return;
        }
        session.removeAttribute(LASTUSER_SESSION_KEY);
        session.invalidate();
        long expires = lastLogin.tsCreated + 120000L;
        if (System.currentTimeMillis() > expires) {
            return;
        }
        String username = lastLogin.username;
        Logs.APP_LOG.debug((Object)("level2 logout for " + username));
        this.logout2User(username, clearRemember, clearPrecooked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout2User(String username, boolean clearRemember, boolean clearPrecooked) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            LoginEAV eav = new LoginEAV(this.mDB.get());
            if (clearRemember) {
                eav.invalidateCookies(username, 1);
            }
            if (clearPrecooked) {
                eav.invalidateCookies(username, 2);
            }
        }
    }

    private UserLogin doLogin(HttpServletRequest req, HttpServletResponse resp, FEUser feuser, BaseAuth.AuthTok auth, LoginCookie lc) {
        boolean isPreCooked;
        boolean isRememberme = lc != null && lc.getType() == 1;
        boolean bl = isPreCooked = lc != null && lc.getType() == 2;
        if (isRememberme) {
            String val = lc.encode();
            Cookie c2 = UserManager.newRememberMeHttpCookie(req, val);
            c2.setMaxAge(31536000);
            resp.addCookie(c2);
        } else {
            Cookie c3 = UserManager.newRememberMeHttpCookie(req, "");
            c3.setMaxAge(0);
            resp.addCookie(c3);
        }
        UserLogin user = new UserLogin(feuser, auth, lc);
        if (isPreCooked) {
            req.setAttribute(USER_ATTR_KEY, (Object)user);
        } else {
            PreferenceManager.touchCookie(req, resp);
            HttpSession session = req.getSession(true);
            session.setAttribute(USER_ATTR_KEY, (Object)user);
        }
        return user;
    }

    private static Cookie newRememberMeHttpCookie(HttpServletRequest req, String val) {
        Cookie c2 = new Cookie(REMEMBERME_COOKIE_NAME, val);
        String ctxPath = req.getContextPath();
        if (ctxPath.length() == 0) {
            ctxPath = "/";
        }
        c2.setPath(ctxPath);
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makePersistentLoginRnd() {
        byte[] b2 = new byte[16];
        Random random = RANDOM;
        synchronized (random) {
            RANDOM.nextBytes(b2);
        }
        return MD5.hexEncode(b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllUsernames() throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            return eav.listAllUserNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCrucibleEnabledUsernames() throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            return eav.listAllCrucibleUserNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupsForUser(String username) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            ArrayList<String> groups = new ArrayList<String>(eav.listGroupsForUser(username));
            if (this.mAuth != null && this.mAuth.supportsGroups()) {
                groups.addAll(this.mAuth.getGroupsForUser(username));
            }
            return groups;
        }
    }

    private boolean userInAnyGroup(UserLogin user, List<String> groups) throws DbException {
        String userName = user.getUserName();
        for (String group : groups) {
            if (!this.isUserInGroup(group, userName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserInGroup(String group, String username) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            if (eav.isUserInGroup(group, username)) {
                return true;
            }
            if (this.mAuth != null && this.mAuth.supportsGroups()) {
                return this.mAuth.isUserInGroup(group, username);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GroupInfo> getGroupInfos() throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            LinkedHashMap<String, GroupInfo> result = new LinkedHashMap<String, GroupInfo>();
            FEGroupEAV geav = new FEGroupEAV(this.mDB.get());
            for (String name : geav.listGroups()) {
                GroupInfo g2 = new GroupInfo(name);
                g2.setBuiltin(true);
                result.put(name, g2);
            }
            if (this.mAuth != null && this.mAuth.supportsGroups()) {
                String authName = FEUser.AUTH_NAMES.get(this.mAuth.getAuthType());
                for (String name : this.mAuth.listGroups()) {
                    GroupInfo g3 = result.get(name);
                    if (g3 == null) {
                        g3 = new GroupInfo(name);
                        result.put(name, g3);
                    }
                    g3.setExternalSource(authName);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean builtInGroupExists(String groupname) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            return eav.groupExists(groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuiltInGroup(String groupname) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            eav.addGroup(groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBuiltInGroup(String groupname) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            eav.deleteGroup(groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToBuiltInGroup(String group, String uname) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            eav.addUserToGroup(group, uname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserFromBuiltInGroup(String group, String uname) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            eav.removeUserFromGroup(group, uname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUsersInGroup(String group) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEGroupEAV eav = new FEGroupEAV(this.mDB.get());
            TreeSet<String> result = new TreeSet<String>(eav.listUsersForGroup(group));
            if (this.mAuth != null && this.mAuth.supportsGroups()) {
                FEUserEAV ueav = new FEUserEAV(this.mDB.get());
                for (String username : this.mAuth.getUsersInGroup(group)) {
                    if (!ueav.usernameExists(username)) continue;
                    result.add(username);
                }
            }
            return new ArrayList<String>(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCount() throws DbException {
        Integer cache = this.mUserCountCache;
        if (cache != null) {
            return cache;
        }
        Object object = this.mDbLock;
        synchronized (object) {
            int count = this.getAllUsernames().size();
            this.mUserCountCache = count;
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameUser(String oldname, String newname) throws DbException {
        newname = this.sanitize(newname);
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            if (!eav.usernameExists(oldname)) {
                throw new DbException("User " + oldname + " does not exist.");
            }
            if (eav.usernameExists(newname)) {
                throw new DbException("User " + newname + " already exists.");
            }
            UserRenamer renamer = new UserRenamer(this.mDB.get());
            renamer.rename(oldname, newname);
        }
    }

    public void addUser(FEUser user, String password) throws DbException, LicensePolicyException {
        this.sanitize(user);
        this.addUserImpl(user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserImpl(FEUser user, String password) throws DbException, LicensePolicyException {
        Object object = this.mDbLock;
        synchronized (object) {
            int max;
            int current;
            if (this.userExists(user.getUsername())) {
                throw new DbException("User named " + user.getUsername() + " already exists.");
            }
            LicenseInfo license = AppConfig.getsConfig().getLicense();
            if (license == null || license.getFisheyeLicense() == null) {
                throw new LicensePolicyException("Could not add user " + user.getUsername() + ". " + "Your FishEye license is missing or invalid.");
            }
            if (license.getFisheyeLicense().isNumberOfUsersLimited() && (current = this.getUserCount()) >= (max = license.getFisheyeLicense().getMaxNumberOfUsers())) {
                throw new LicensePolicyException("Could not add user " + user.getUsername() + ". " + "Your license does not permit more than " + max + " users.");
            }
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            user.setPasswordHash(password == null ? null : MD5.hash(password));
            eav.update(user);
            if (AppConfig.isCrucible()) {
                try {
                    this.setCrucibleEnabled(user.getUsername(), true);
                }
                catch (LicenseException e2) {
                    Logs.APP_LOG.info((Object)("Newly-added user " + user.getUsername() + " could not be made a Crucible user:" + e2.getMessage()));
                }
                Logs.APP_LOG.debug((Object)"adding user to crucible DB");
                try {
                    AppConfig.getCrucibleBridge().createCrucibleUser(user.getUsername());
                }
                catch (Exception e3) {
                    throw new DbException("Unexpected error adding user named " + user.getUsername() + " to the crucible database.", e3);
                }
            }
            this.mUserCountCache = null;
        }
    }

    private void sanitize(FEUser user) {
        user.setUsername(this.sanitize(user.getUsername()));
    }

    private String sanitize(String username) {
        if (username == null) {
            return null;
        }
        return this.forceLowercase() ? username.toLowerCase(Locale.US) : username;
    }

    private boolean forceLowercase() {
        ConfigDocument.Config config = AppConfig.getsConfig().getConfig();
        if (config.isSetSecurity() && config.getSecurity().isSetUsernames()) {
            return config.getSecurity().getUsernames().getForceLowercase();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(FEUser user, String password) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            user.setPasswordHash(password == null ? null : MD5.hash(password));
            eav.update(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(FEUser user) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            eav.update(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userExists(String username) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            return eav.usernameExists(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FEUser getUser(String username) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            return eav.load(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsernameByEmail(String email) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            return eav.getUsernameForEmail(email);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(FEUser user) throws DbException {
        Object object = this.mDbLock;
        synchronized (object) {
            String username = user.getUsername();
            WatchEAV weav = new WatchEAV(this.mDB.get());
            List<Watch> watches = weav.getWatchesForUser(username);
            for (Watch watch : watches) {
                weav.delete(watch.getId());
            }
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            eav.delete(username);
            this.mUserCountCache = null;
        }
    }

    public boolean hasPermissionToAccess(UserLogin user, RepositoryHandle handle) {
        boolean loggedin;
        boolean bl = loggedin = user != null;
        if (loggedin) {
            return this.hasPermissionToAccessImpl(user, handle);
        }
        return handle.getCfg().isAnonAccessAllowed();
    }

    private boolean hasPermissionToAccessImpl(UserLogin user, RepositoryHandle handle) {
        try {
            List<String> groups = handle.getCfg().getAllowedGroups();
            if (groups.isEmpty() && this.mAuth == null) {
                return true;
            }
            if (this.userInAnyGroup(user, groups)) {
                return true;
            }
            if (this.mAuth != null) {
                BaseAuth.AuthTok auth = user.getAuthTok();
                boolean defaultResult = groups.isEmpty();
                return this.mAuth.hasPermissionToAccess(auth, defaultResult, handle);
            }
            return false;
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Could not do group check", (Throwable)e2);
            return false;
        }
    }

    public boolean isCrucibleEnabled(String username) throws DbException {
        FEUser user = this.getUser(username);
        return user == null ? false : user.isCrucibleEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrucibleEnabled(String username, boolean enable) throws DbException, LicenseException {
        Object object = this.mDbLock;
        synchronized (object) {
            int max;
            int current;
            FEUserEAV eav = new FEUserEAV(this.mDB.get());
            FEUser user = eav.load(username);
            if (user == null) {
                return;
            }
            if (user.isCrucibleEnabled() == enable) {
                return;
            }
            if (!enable) {
                eav.setCrucibleEnabled(username, false);
                return;
            }
            LicenseInfo license = AppConfig.getsConfig().getLicense();
            if (license.getCrucibleLicense().isNumberOfUsersLimited() && (current = eav.countNumberOfCrucibleUsers()) >= (max = license.getCrucibleLicense().getMaxCrucibleUsers())) {
                throw new LicenseException("You have reached your maximum of " + max + " Crucible users.");
            }
            eav.setCrucibleEnabled(username, true);
        }
    }

    public boolean isLoginPossible() throws DbException {
        boolean signupEnabled = AppConfig.getsConfig().getConfig().getSecurity().getBuiltIn().getSignup().getEnabled();
        return this.mAutoImport || signupEnabled || this.getUserCount() > 0;
    }

    static {
        long t0 = System.currentTimeMillis();
        RANDOM = new SecureRandom();
        RANDOM.nextBytes(new byte[1]);
        long t1 = System.currentTimeMillis();
        Logs.PERF_LOG.debug((Object)("created SecureRandom in " + (t1 - t0) + "ms"));
    }

    public static class LastLogin {
        public final String username;
        public final long tsCreated = System.currentTimeMillis();

        public LastLogin(String username) {
            this.username = username;
        }
    }
}

