/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class AntGlob {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private final List patDirs;
    private final String mPatternString;
    private final boolean mCaseSensitiveDefault;

    public AntGlob(String pattern) {
        this(pattern, false);
    }

    public AntGlob(String pattern, boolean isCaseSensitive) {
        this.mCaseSensitiveDefault = isCaseSensitive;
        this.mPatternString = pattern = pattern.replace('\\', '/');
        this.patDirs = new ArrayList();
        if (!pattern.startsWith("/")) {
            this.patDirs.add("**");
        }
        AntGlob.split(pattern, this.patDirs);
        if (pattern.endsWith("/")) {
            this.patDirs.add("**");
        }
    }

    public String pattern() {
        return this.mPatternString;
    }

    public boolean matches(CharSequence path) {
        return this.matchPath(path, this.mCaseSensitiveDefault);
    }

    public boolean matches(CharSequence path, boolean isCaseSensitive) {
        return this.matchPath(path, isCaseSensitive);
    }

    private boolean matchPath(CharSequence str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        ArrayList strDirs = new ArrayList();
        AntGlob.split(str, strDirs);
        int patIdxStart = 0;
        int patIdxEnd = this.patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)this.patDirs.get(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (AntGlob.match(patDir, (CharSequence)strDirs.get(strIdxStart), isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (this.patDirs.get(i2).equals("**")) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)this.patDirs.get(patIdxEnd)).equals("**")) {
            if (!AntGlob.match(patDir, (CharSequence)strDirs.get(strIdxEnd), isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (this.patDirs.get(i3).equals("**")) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!this.patDirs.get(i4).equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j = 0; j < patLength; ++j) {
                    CharSequence subStr;
                    String subPat = (String)this.patDirs.get(patIdxStart + j + 1);
                    if (!AntGlob.match(subPat, subStr = (CharSequence)strDirs.get(strIdxStart + i5 + j), isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (this.patDirs.get(i6).equals("**")) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, CharSequence str, boolean isCaseSensitive) {
        char ch;
        int i2;
        char[] patArr = pattern.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = str.length() - 1;
        boolean containsStar = false;
        for (i2 = 0; i2 < patArr.length; ++i2) {
            if (patArr[i2] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?') continue;
                if (isCaseSensitive && ch2 != str.charAt(i2)) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(str.charAt(i2))) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != str.charAt(strIdxStart)) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(str.charAt(strIdxStart))) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != str.charAt(strIdxEnd)) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(str.charAt(strIdxEnd))) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i3 = patIdxStart + 1; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] != '*') continue;
                patIdxTmp = i3;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i4 = 0; i4 <= strLength - patLength; ++i4) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && (isCaseSensitive && ch != str.charAt(strIdxStart + i4 + j) || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(str.charAt(strIdxStart + i4 + j)))) continue block8;
                }
                foundIdx = strIdxStart + i4;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
            if (patArr[i2] == '*') continue;
            return false;
        }
        return true;
    }

    private static void split(CharSequence path, List dest) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.subSequence(1, path.length());
        }
        String[] parts = SPLIT_PATTERN.split(path);
        dest.addAll(Arrays.asList(parts));
    }

    public static boolean containsPathSeperator(String s) {
        return s.indexOf(47) != -1 || s.indexOf(92) != -1;
    }

    public static boolean containsWildcards(String s) {
        return s.indexOf(42) != -1 || s.indexOf(63) != -1;
    }

    public String toString() {
        return "AntGlob<" + this.mPatternString + ",cs=" + this.mCaseSensitiveDefault + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AntGlob antGlob = (AntGlob)o;
        if (this.mCaseSensitiveDefault != antGlob.mCaseSensitiveDefault) {
            return false;
        }
        return ((Object)this.patDirs).equals(antGlob.patDirs);
    }

    public int hashCode() {
        int result = ((Object)this.patDirs).hashCode();
        result = 29 * result + (this.mCaseSensitiveDefault ? 1 : 0);
        return result;
    }
}

