/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.license.CenquaLicenseWrapper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Zipper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class FishEyeBackup {
    private final DateFormat format = new SimpleDateFormat("yyyyddMMHHmmss");
    private final Logger statusLogger;

    public FishEyeBackup(Logger logger) {
        this.statusLogger = logger != null ? logger : Logs.makeAnonymousLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(File backupFile) throws IOException, DbException, ConfigException {
        IOHelper.mkdirs(backupFile.getParentFile());
        IOHelper.createNewFile(backupFile);
        RootConfig rootConfig = AppConfig.getsConfig();
        Object object = rootConfig.getDB0Lock();
        synchronized (object) {
            try {
                rootConfig.closeDB();
                if (AppConfig.isCrucible()) {
                    AppConfig.getCrucibleBridge().stop();
                }
                Zipper zipper = new Zipper(this.statusLogger);
                this.addLicense(zipper, rootConfig.getLicense().getFisheyeLicense());
                this.addLicense(zipper, rootConfig.getLicense().getCrucibleLicense());
                zipper.add(new Path("config.xml"), rootConfig.getConfigFile());
                zipper.add(new Path("var/data"), AppConfig.getDataDir());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(backupFile));
                zipper.zip(out);
            }
            finally {
                rootConfig.openDB();
                if (AppConfig.isCrucible()) {
                    AppConfig.getCrucibleBridge().startup();
                }
            }
        }
        this.statusLogger.info((Object)("Saved backup to: " + backupFile.getAbsolutePath()));
    }

    private void addLicense(Zipper zipper, CenquaLicenseWrapper license) {
        if (license == null) {
            return;
        }
        File file = license.getLicenseFile();
        if (file == null) {
            return;
        }
        zipper.add(new Path(file.getName()), file);
    }

    public File backup() throws IOException, DbException, ConfigException {
        RootConfig rootConfig = AppConfig.getsConfig();
        File backupDir = new File(AppConfig.getInstanceDir(), "backup");
        String filename = "backup_" + this.format.format(new Date());
        File backupFile = new File(backupDir, filename + ".zip");
        this.backup(backupFile);
        return backupFile;
    }
}

