/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.vis.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BranchTable {
    private final Graph mGraph;
    private final List mColumns = new ArrayList();
    private final Map mBranchPositions = new HashMap();

    public BranchTable(Graph graph) {
        this.mGraph = graph;
    }

    public int getNumColumns() {
        return this.mColumns.size();
    }

    private void add(String br) {
        BranchInfo info = this.makeInfo(br);
        this.addToColumn(this.mColumns.size(), info);
        this.mBranchPositions.put(br, new Float(0.0f));
    }

    private void add(String parent, String br) {
        BranchInfo info = this.makeInfo(br);
        String parentBranch = this.mGraph.getBranchOf(parent);
        int desiredCol = this.getBranchColPos(parentBranch) + 1;
        float desiredRow = this.getNodeRowPos(parent) + 0.5f;
        float height = info.getHeight();
        while (!this.isSpaceFree(desiredCol, desiredRow, height)) {
            ++desiredCol;
        }
        this.addToColumn(desiredCol, info);
        this.mBranchPositions.put(br, new Float(desiredRow));
    }

    private BranchInfo makeInfo(String br) {
        List revs = this.mGraph.getBranch(br);
        ArrayList shortList = new ArrayList(revs);
        int goodCount = 1;
        for (int i2 = 1; i2 < shortList.size() - 1; ++i2) {
            String rev = (String)shortList.get(i2);
            if (this.mGraph.isBranchPoint(rev)) {
                ++goodCount;
                continue;
            }
            shortList.set(i2, null);
        }
        if (shortList.size() > 1) {
            ++goodCount;
        }
        boolean[] skipPreceeds = new boolean[goodCount];
        int i3 = 0;
        boolean skipping = false;
        Iterator j = shortList.iterator();
        while (j.hasNext()) {
            String rev = (String)j.next();
            if (rev == null) {
                j.remove();
                skipping = true;
                continue;
            }
            skipPreceeds[i3++] = skipping;
            skipping = false;
        }
        return new BranchInfo(br, shortList, skipPreceeds);
    }

    private void addToColumn(int col, BranchInfo info) {
        if (col >= this.mColumns.size()) {
            ArrayList<BranchInfo> brs = new ArrayList<BranchInfo>();
            brs.add(info);
            this.mColumns.add(brs);
        } else {
            List brs = (List)this.mColumns.get(col);
            brs.add(info);
        }
    }

    private boolean isSpaceFree(int col, float row, float height) {
        if (col >= this.mColumns.size()) {
            return true;
        }
        List brs = (List)this.mColumns.get(col);
        for (BranchInfo info : brs) {
            float h2;
            float r0 = this.getBranchTop(info.br);
            if (!this.overlaps(row, height, r0, h2 = info.getHeight())) continue;
            return false;
        }
        return true;
    }

    private boolean overlaps(float r0, float h0, float r1, float h1) {
        float r0e = r0 + h0;
        float r1e = r1 + h1;
        return r0 <= r1 && r1 <= r0e || r0 <= r1e && r1e <= r0e || r1 <= r0 && r0 <= r1e || r1 <= r0e && r0e <= r1e;
    }

    public float getNodeRowPos(String rev) {
        String br = this.mGraph.getBranchOf(rev);
        BranchInfo info = this.getInfo(br);
        int idx = info.revs.indexOf(rev);
        return this.getBranchFirstPos(br) + (float)idx;
    }

    public float getBranchFirstPos(String br) {
        Float i2 = (Float)this.mBranchPositions.get(br);
        return i2.floatValue() + 1.0f;
    }

    public float getBranchTop(String br) {
        Float i2 = (Float)this.mBranchPositions.get(br);
        return i2.floatValue();
    }

    public int getBranchColPos(String br) {
        for (int i2 = 0; i2 < this.mColumns.size(); ++i2) {
            List list = (List)this.mColumns.get(i2);
            for (int j = 0; j < list.size(); ++j) {
                BranchInfo info = (BranchInfo)list.get(j);
                if (!info.br.equals(br)) continue;
                return i2;
            }
        }
        return -1;
    }

    private boolean containsBranch(String br) {
        return this.mBranchPositions.containsKey(br);
    }

    public void collate() {
        Graph.Visitor v = new Graph.Visitor(){

            public void visitingBranch(String br) {
                String parent = BranchTable.this.mGraph.getBranchPoint(br);
                if (parent == null) {
                    BranchTable.this.add(br);
                } else if (BranchTable.this.containsBranch(BranchTable.this.mGraph.getBranchOf(parent))) {
                    BranchTable.this.add(parent, br);
                } else {
                    BranchTable.this.add(br);
                }
            }
        };
        this.mGraph.visitSpudOrder(v, false);
    }

    public BranchInfo getInfo(String br) {
        for (int i2 = 0; i2 < this.mColumns.size(); ++i2) {
            List list = (List)this.mColumns.get(i2);
            for (int j = 0; j < list.size(); ++j) {
                BranchInfo info = (BranchInfo)list.get(j);
                if (!info.br.equals(br)) continue;
                return info;
            }
        }
        return null;
    }

    public List getColumn(int idx) {
        return (List)this.mColumns.get(idx);
    }

    public static class BranchInfo {
        final String br;
        private final List revs;
        private final boolean[] skipPreceeds;

        public BranchInfo(String br, List revs, boolean[] skipPreceeds) {
            this.br = br;
            this.revs = revs;
            this.skipPreceeds = skipPreceeds;
        }

        public String getBr() {
            return this.br;
        }

        public float getHeight() {
            return this.revs.size() + 1;
        }

        public int getNumRevisions() {
            return this.revs.size();
        }

        public String getRevision(int i2) {
            return (String)this.revs.get(i2);
        }

        public boolean doesSkipPreceed(int idx) {
            return this.skipPreceeds[idx];
        }
    }
}

