/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class LineCountChartLine
extends LineCountChart {
    XYPlot createLineCountPlot(XYSeriesCollection lineHistory, boolean isMiniChart) {
        XYLineAndShapeRenderer lcRenderer = new XYLineAndShapeRenderer(true, false);
        lcRenderer.setLegendLine((Shape)new Rectangle(20, 20));
        lcRenderer.setBaseSeriesVisibleInLegend(false);
        XYPlot lcPlot = this.createXYPlot((XYDataset)lineHistory, null, this.createValueAxis(), (XYItemRenderer)lcRenderer, isMiniChart ? 4 : 6);
        if (isMiniChart) {
            lcRenderer.setBaseOutlineStroke((Stroke)new BasicStroke(5.0f));
            lcPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
            lcPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        } else {
            lcRenderer.setBaseStroke((Stroke)new BasicStroke(3.0f, 1, 1));
            for (int i2 = 0; i2 < lineHistory.getSeriesCount(); ++i2) {
                lcRenderer.setSeriesPaint(i2, LineCountChartUtils.getXYColour(i2));
                lcRenderer.setSeriesOutlinePaint(i2, LineCountChartUtils.getXYColour(i2));
            }
        }
        this.addDomainMarker(lcPlot);
        return lcPlot;
    }

    XYPlot createCommitHistoryPlot(XYDataset commitHistory, boolean isMiniChart, boolean visibleInLegend) {
        XYPlot volPlot;
        ValueAxis volRangeAxis = this.createValueAxis();
        if (isMiniChart) {
            XYBarRenderer volRenderer = new XYBarRenderer();
            volRenderer.setSeriesPaint(0, (Paint)Color.blue.darker());
            volRenderer.setLegendBar((Shape)new Rectangle(20, 20));
            volPlot = this.createXYPlot(commitHistory, null, volRangeAxis, (XYItemRenderer)volRenderer, 4);
            volPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        } else {
            StackedXYBarRenderer volRenderer = new StackedXYBarRenderer();
            volRenderer.setMargin(0.0);
            volRenderer.setBaseSeriesVisibleInLegend(visibleInLegend);
            volRenderer.setLegendBar((Shape)new Rectangle(20, 20));
            for (int i2 = 0; i2 < commitHistory.getSeriesCount(); ++i2) {
                volRenderer.setSeriesPaint(i2, LineCountChartUtils.getXYColour(i2));
            }
            volPlot = this.createXYPlot(commitHistory, null, volRangeAxis, (XYItemRenderer)volRenderer, 4);
        }
        this.addDomainMarker(volPlot);
        return volPlot;
    }
}

