/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.CommandString;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class FishEyePathInfo {
    private static final String COMMAND_PREFIX = "~";
    private final String repname;
    private final Path fullpath;
    private final Path localpath;
    private final CommandString commandString;
    private final boolean empty;
    private RepositoryHandle handle;
    private RepositoryEngine engine;

    public FishEyePathInfo(HttpServletRequest req) {
        this(req.getPathInfo());
    }

    public FishEyePathInfo(String pi) {
        this(pi == null ? new Path() : new Path(pi).simplify());
    }

    public FishEyePathInfo(Path path) {
        if (path.numComponents() > 0 && path.getComponent(0).startsWith(COMMAND_PREFIX)) {
            String cmdStr = path.getComponent(0);
            this.commandString = new CommandString(cmdStr.substring(COMMAND_PREFIX.length()));
            path = path.trimFirst();
        } else {
            this.commandString = null;
        }
        List<String> allParts = Arrays.asList(path.getComponents());
        if (allParts.size() == 0) {
            this.fullpath = new Path();
            this.localpath = new Path();
            this.repname = null;
            this.empty = true;
        } else {
            this.repname = path.getComponent(0);
            this.fullpath = path;
            this.localpath = path.trimFirst();
            this.empty = false;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public CommandString getCommandString() {
        return this.commandString;
    }

    public String getCommandWord() {
        return this.commandString == null ? null : this.commandString.getCommandWord();
    }

    public String getCommandParam(String key) {
        return this.commandString == null ? null : this.commandString.getCommandParam(key);
    }

    public RepositoryConfig getRepository() {
        return this.handle.getCfg();
    }

    public RepositoryHandle getHandle() {
        return this.handle;
    }

    public String getRepname() {
        return this.repname;
    }

    public void initEngine(RepositoryHandle handle) throws RepositoryHandle.StateException {
        this.handle = handle;
        this.engine = this.handle.acquireEngine();
    }

    public RepositoryEngine getEngine() {
        return this.engine;
    }

    public Path getFullPath() {
        return this.fullpath;
    }

    public Path getLocalPath() {
        return this.localpath;
    }
}

