/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.web.UrlHelper;

public class SearchResultPager {
    private UrlHelper mBaseUrl = new UrlHelper();
    private int mThisPageNum = 0;
    private int mTotalPages = 0;
    private int mNeighbours = 10;
    private int mNeighbourPageNum;

    public SearchResultPager() {
    }

    public SearchResultPager(UrlHelper baseUrl, int thisPageNum, int totalPages) {
        this.mBaseUrl = baseUrl;
        this.mThisPageNum = thisPageNum;
        this.mTotalPages = totalPages;
    }

    public int getThisPageNum() {
        return this.mThisPageNum;
    }

    public int getTotalPages() {
        return this.mTotalPages;
    }

    public String getPageUrl(int page) {
        UrlHelper url = this.mBaseUrl.getClone();
        url.putParam("spage", page);
        return url.toString();
    }

    public boolean showLinkPrevious() {
        return this.mThisPageNum > 1;
    }

    public boolean showLink1() {
        return this.mThisPageNum > this.mNeighbours + 1;
    }

    public boolean showLinkLast() {
        return this.mThisPageNum + this.mNeighbours < this.mTotalPages;
    }

    public boolean showLinkNext() {
        return this.mThisPageNum < this.mTotalPages;
    }

    public boolean showFirstEllipsis() {
        return this.mThisPageNum > this.mNeighbours + 2;
    }

    public boolean showSecondEllipsis() {
        return this.mThisPageNum + this.mNeighbours < this.mTotalPages - 1;
    }

    public void initNeighbours() {
        this.mNeighbourPageNum = this.getMinPage();
    }

    public void nextNeighbour() {
        ++this.mNeighbourPageNum;
    }

    public String getNeighbourUrl() {
        return this.getPageUrl(this.mNeighbourPageNum);
    }

    public int getMinPage() {
        return Math.max(this.mThisPageNum - this.mNeighbours, 1);
    }

    public int getMaxPage() {
        return Math.min(this.mThisPageNum + this.mNeighbours, this.mTotalPages);
    }
}

