/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class EditTarballMaxFilesAction
extends BaseRepositoryAction {
    private TarballType tarball = TarballType.Factory.newInstance();
    boolean limited = false;

    public TarballType getTarball() {
        return this.tarball;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public String execute() throws Exception {
        TarballType editing;
        if (this.isDefault()) {
            editing = this.getCfg().getRepositoryDefaults().getTarball();
        } else {
            try {
                editing = this.getCfg().getRepositoryArray(this.getRep()).getTarball();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
        }
        if (editing == null) {
            this.addActionError("No Tarball element to edit, rep=" + this.getRep());
            return "error";
        }
        if (!this.limited) {
            if (editing.isSetMaxFileCount()) {
                editing.unsetMaxFileCount();
            }
        } else {
            editing.setMaxFileCount(this.tarball.getMaxFileCount());
        }
        this.saveCfg();
        return "success";
    }

    public String doDefault() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        TarballType editing = null;
        if (this.isDefault()) {
            editing = cfg.getRepositoryDefaults().getTarball();
        } else {
            RepositoryType repository = null;
            try {
                repository = cfg.getRepositoryArray(this.getRep());
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
            editing = repository.getTarball();
        }
        if (editing == null) {
            this.addActionError("No Tarball element to edit, rep=" + this.getRep());
            return "error";
        }
        if (editing.isSetMaxFileCount()) {
            this.limited = true;
            this.tarball.setMaxFileCount(editing.getMaxFileCount());
        }
        return "success";
    }
}

