/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAction;
import java.util.regex.Pattern;

public class UserAddAction
extends BaseUserAction {
    public static final Pattern USERNAME_PATTERN = Pattern.compile("[a-zA-Z0-9\\-_\\.@]+");
    public static final String USERNAME_PATTERN_DESC = "alphanumeric, underscore, at ('@'), dot or dash";
    private String password1;
    private String password2;

    public String getPassword1() {
        return this.password1;
    }

    public void setPassword1(String password1) {
        this.password1 = password1;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public String execute() {
        try {
            UserManager um = UserAddAction.getUserManager();
            um.addUser(this.user, this.password1);
            if (AppConfig.isCrucible()) {
                try {
                    um.setCrucibleEnabled(this.user.getUsername(), true);
                }
                catch (LicenseException e2) {
                    this.addActionMessage("Could not enable Crucible for user. " + e2.getMessage());
                }
            }
            return "success";
        }
        catch (DbException e3) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e3);
            this.addActionError("Internal problem adding user (check logs)");
            return "input";
        }
        catch (LicensePolicyException e4) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e4);
            this.addActionError("Problem adding user: " + e4.getMessage());
            return "input";
        }
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        UserManager um = UserAddAction.getUserManager();
        try {
            String existingUser;
            if (um.userExists(this.user.getUsername())) {
                this.addFieldError("user.username", "User by that name already exists");
            }
            if (!StringUtil.nullOrEmpty(this.user.getEmail()) && (existingUser = um.getUsernameByEmail(this.user.getEmail())) != null) {
                this.addFieldError("user.email", "Email address must be unique, currently used by " + existingUser);
            }
            if (!USERNAME_PATTERN.matcher(this.user.getUsername()).matches()) {
                this.addFieldError("user.username", "Username can only contain alphanumeric, underscore, at ('@'), dot or dash");
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem adding user", (Throwable)e2);
            this.addActionError("Internal problem adding user (check logs)");
        }
        if (this.user.getAuthType() == 1) {
            this.checkPassword(this.password1, this.password2);
        } else {
            this.password1 = null;
            this.password2 = null;
        }
    }
}

