/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAction;

public class UserEditAction
extends BaseUserAction {
    private String uname;
    private boolean updateCruStatus = false;
    private boolean newlyAdded = false;

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public boolean getUpdateCruStatus() {
        return this.updateCruStatus;
    }

    public void setUpdateCruStatus(boolean updateCruStatus) {
        this.updateCruStatus = updateCruStatus;
    }

    public String doDefault() throws Exception {
        this.user = this.loadUser(this.uname);
        return "success";
    }

    public String execute() throws Exception {
        boolean cruEnabled;
        FEUser realUser = this.loadUser(this.uname);
        realUser.setDisplayName(this.user.getDisplayName());
        realUser.setEmail(this.user.getEmail());
        realUser.setAuthType(this.user.getAuthType());
        UserManager um = UserEditAction.getUserManager();
        if (AppConfig.isCrucible() && this.updateCruStatus && (cruEnabled = this.user.isCrucibleEnabled()) != realUser.isCrucibleEnabled()) {
            try {
                um.setCrucibleEnabled(realUser.getUsername(), cruEnabled);
            }
            catch (LicenseException e2) {
                this.addActionError(e2.getMessage());
                this.user = realUser;
                return "input";
            }
        }
        um.updateUser(realUser);
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        UserManager um = UserEditAction.getUserManager();
        try {
            String existingUser = um.getUsernameByEmail(this.user.getEmail());
            if (existingUser != null && !existingUser.equals(this.uname)) {
                this.addFieldError("user.email", "Email address must be unique, currently used by " + existingUser);
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem changing user", (Throwable)e2);
            this.addActionError("Internal problem adding user (check logs)");
        }
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newlyAdded) {
        this.newlyAdded = newlyAdded;
    }
}

