/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.jetty;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.jetty.FishEyeWebApplicationContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.StreamEndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.LocalConnector;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;

public class JspRenderer {
    private final FishEyeWebApplicationContext webapp;
    private final LocalConnector listener;

    public JspRenderer(FishEyeWebApplicationContext webapp, LocalConnector listener) {
        this.webapp = webapp;
        this.listener = listener;
    }

    public void render(String pathInContext, Map attrs, OutputStream out) throws IOException, ServletException {
        String uriPath = Path.join(this.webapp.getContextPath(), pathInContext);
        HttpConnection con = new HttpConnection((Connector)this.listener, this.makeEndPoint(uriPath, out), this.webapp.getServer());
        HttpURI uri = new HttpURI(uriPath);
        Request req = con.getRequest();
        req.setProtocol("HTTP/1.0");
        req.setMethod("GET");
        req.setUri(uri);
        req.setContextPath(this.webapp.getContextPath());
        req.setPathInfo(pathInContext);
        if (attrs != null) {
            for (Map.Entry e2 : attrs.entrySet()) {
                req.setAttribute((String)e2.getKey(), e2.getValue());
            }
        }
        Response res = con.getResponse();
        res.setCharacterEncoding("UTF-8");
        con.handle();
        res.flushBuffer();
    }

    private EndPoint makeEndPoint(String uriPath, OutputStream out) {
        StringBuffer request = new StringBuffer();
        request.append("GET ").append(uriPath).append(" HTTP/1.0\r\n\r\n");
        ByteArrayInputStream ins = new ByteArrayInputStream(request.toString().getBytes());
        SkipHttpHeaderOutputStream outs = new SkipHttpHeaderOutputStream(out);
        return new StreamEndPoint((InputStream)ins, (OutputStream)outs);
    }

    public static class SkipHttpHeaderOutputStream
    extends OutputStream {
        private static final String HEADERS_END = "\r\n\r\n";
        private final StringBuffer header = new StringBuffer(200);
        private boolean doneSkipping = false;
        private final OutputStream out;

        public SkipHttpHeaderOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(int b2) throws IOException {
            if (this.doneSkipping) {
                this.out.write(b2);
            } else {
                this.header.append((char)b2);
                if (StringUtil.endsWith(this.header, HEADERS_END)) {
                    this.doneSkipping = true;
                }
            }
        }
    }
}

