/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EditAuthorMappingAction
extends AbstractProfileAction {
    private UserProfile.AuthorMappings authorMappings = UserProfile.AuthorMappings.fromString("");
    private String rep;
    private String author;

    public void setRep(String rep) {
        this.rep = rep;
    }

    public String getRep() {
        return this.rep;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public List getRepositories() {
        return RepositoryUtil.repositories(this.request);
    }

    public Set getMappedReps() {
        return this.authorMappings.getMappedReps();
    }

    public Set getUnmappedReps() {
        HashSet<String> results = new HashSet<String>();
        for (RepositoryHandle handle : this.getRepositories()) {
            results.add(handle.getName());
        }
        for (String rep : this.getMappedReps()) {
            results.remove(rep);
        }
        return results;
    }

    public String getMappedAuthor(String rep) {
        return this.authorMappings.getAuthorForRep(rep);
    }

    public String getSuggestedAuthor(String rep) {
        String user = this.profile.getUsername();
        int bestDistance = Integer.MAX_VALUE;
        String best = null;
        for (String author : this.getAuthors(rep)) {
            int distance = StringUtil.editDistance(user, author);
            if (distance >= bestDistance) continue;
            bestDistance = distance;
            best = author;
        }
        return best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAuthors(String rep) {
        List<Object> results = new ArrayList();
        RepositoryHandle handle = AppConfig.getsConfig().getRepositoryManager().getRepository(rep);
        if (handle != null) {
            try {
                Disposer.pushThreadInstance();
                results = handle.acquireEngine().getRevisionCache().findAuthors(new Path("/"));
            }
            catch (DbException e2) {
            }
            catch (RepositoryHandle.StateException e3) {
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
        return results;
    }

    public String deleteMapping() throws Exception {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            this.configChangePasswordEnabled(user.getUsername());
            this.profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
            this.profile.getAuthorMappings().deleteMapping(this.rep);
            AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), this.profile);
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    public String editMapping() throws Exception {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            this.configChangePasswordEnabled(user.getUsername());
            this.profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
            this.profile.getAuthorMappings().addMapping(this.rep, this.author);
            AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), this.profile);
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    public String execute() throws Exception {
        UserLogin user = this.getUserLogin();
        try {
            if (user != null) {
                this.configChangePasswordEnabled(user.getUsername());
                this.profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                this.authorMappings = this.profile.getAuthorMappings();
                if (this.rep != null) {
                    this.author = this.authorMappings.getAuthorForRep(this.rep);
                    if (this.author == null) {
                        this.author = this.getSuggestedAuthor(this.rep);
                    }
                }
                return "success";
            }
            this.addActionError("User not found");
        }
        catch (DbException e2) {
            this.addActionError("Database error loading user profile");
        }
        return "error";
    }
}

