/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.rdiff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionContentsUtil;
import com.cenqua.fisheye.cvsrep.cache.CachedCvsRepository;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.FileDiffExplorer;
import com.cenqua.fisheye.web.ViewFileAction;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PatchPrinter {
    private static String[] RFC822_MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String MSG_PREFIX = "FishEye";
    private PatchOptions mOpts = new PatchOptions();
    private final RevisionCache mCRep;
    private final Writer out;

    public PatchPrinter(RevisionCache CRep, Writer out) {
        this.mCRep = CRep;
        this.out = out;
    }

    public PatchOptions getOpts() {
        return this.mOpts;
    }

    public void setOpts(PatchOptions opts) {
        this.mOpts = opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAddedFile(Path path, String rs2) throws IOException, DbException {
        Disposer disposer = Disposer.pushThreadInstance();
        try {
            FileHistory hist;
            try {
                hist = this.mCRep.getFileHistory(path);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"problem sending diff, skipping", (Throwable)e2);
                this.out.write("FishEye: error with file: " + e2.getMessage() + "\n");
                Disposer.popThreadInstance();
                return;
            }
            FileRevision rev2 = hist.getRevision(rs2);
            if (rev2 == null) {
                this.out.write("FishEye: no such revision " + rs2 + " for file " + path + "\n");
                return;
            }
            if (hist.isBinary()) {
                this.writeDiffHeader(hist, null, rev2);
                this.out.write("Binary files differ\n");
                return;
            }
            this.writeDiffHeader(hist, null, rev2);
            this.writeWholeFile(disposer, true, rev2);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFileDiff(Path path, String rs1, String rs2) throws IOException, DbException {
        Disposer disposer = Disposer.pushThreadInstance();
        try {
            boolean r2IsMissing;
            FileHistory hist;
            try {
                hist = this.mCRep.getFullFileHistory(path);
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"problem sending diff, skipping", (Throwable)e2);
                this.out.write("FishEye: error with file: " + e2.getMessage() + "\n");
                Disposer.popThreadInstance();
                return;
            }
            FileRevision rev1 = hist.getRevision(rs1);
            FileRevision rev2 = hist.getRevision(rs2);
            boolean r1IsMissing = rev1 == null || rev1.isDead();
            boolean bl = r2IsMissing = rev2 == null || rev2.isDead();
            if (r1IsMissing && r2IsMissing) {
                return;
            }
            if (hist.isBinary()) {
                this.writeBinaryDiff(disposer, hist, rev1, rev2);
                return;
            }
            if (r1IsMissing) {
                if (this.mOpts.absentAsEmpty) {
                    this.writeDiffHeader(hist, null, rev2);
                    this.writeWholeFile(disposer, true, rev2);
                } else {
                    this.writeIsDeadMsg(rs1, rev1, path);
                }
                return;
            }
            if (r2IsMissing) {
                if (this.mOpts.absentAsEmpty) {
                    this.writeDiffHeader(hist, rev1, null);
                    this.writeWholeFile(disposer, false, rev1);
                } else {
                    this.writeIsDeadMsg(rs2, rev2, path);
                }
                return;
            }
            if (rev1.getRevision().equals(rev2.getRevision())) {
                return;
            }
            LineComparator.Identical ignore = this.mOpts.ignore == null ? LineComparator.IDENTICAL : this.mOpts.ignore;
            FileDiffExplorer diffs = ViewFileAction.diffRevisions(disposer, this.mCRep, rev1, rev2, ignore, this.mOpts.kOpt, false, false);
            this.writeDiff(hist, rev1, rev2, diffs);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void writeIsDeadMsg(String rs1, FileRevision rev, Path path) throws IOException {
        if (rev == null) {
            this.out.write("FishEye: tag " + rs1 + " is not in file " + path + "\n");
        } else {
            this.out.write("FishEye: Tag " + rs1 + " refers to a dead (removed) revision in file `" + path + "'.\n");
            this.out.write("FishEye: No comparison available.  Pass `N' to diff?\n");
        }
    }

    private void writeBinaryDiff(Disposer disposer, FileHistory hist, FileRevision rev1, FileRevision rev2) throws IOException, DbException {
        boolean identical;
        boolean bl = rev1 == null || rev2 == null ? false : (identical = !ViewFileAction.diffBinaryRevisions(disposer, this.mCRep, rev1.getRevInfoKey(), rev2.getRevInfoKey()));
        if (identical) {
            return;
        }
        this.writeDiffHeader(hist, rev1, rev2);
        this.out.write("Binary files differ\n");
    }

    private void writeDiff(FileHistory hist, FileRevision rev1, FileRevision rev2, FileDiffExplorer diffs) throws IOException {
        Section nextFirst;
        if (diffs.isIdentical()) {
            return;
        }
        this.writeDiffHeader(hist, rev1, rev2);
        diffs.setContextLines(this.mOpts.linesOfContext);
        List sections = diffs.getSections();
        ArrayList<Section> hunk = new ArrayList<Section>();
        Iterator i2 = sections.iterator();
        Section section = nextFirst = i2.hasNext() ? (Section)i2.next() : null;
        while (nextFirst != null) {
            hunk.clear();
            Section first = nextFirst;
            nextFirst = null;
            int size1 = first.getFromLength();
            int size2 = first.getToLength();
            hunk.add(first);
            while (i2.hasNext()) {
                Section next = (Section)i2.next();
                if (next.isSkippedPrevious()) {
                    nextFirst = next;
                    break;
                }
                hunk.add(next);
                size1 += next.getFromLength();
                size2 += next.getToLength();
            }
            this.out.write("@@ -" + this.rangeString(first.getFromStart() + 1, size1) + " +" + this.rangeString(first.getToStart() + 1, size2) + " @@\n");
            for (Section s : hunk) {
                if (s.isCommonSubsequence()) {
                    this.writeLines(" ", diffs.getLines1(), s.getFromStart(), s.getFromLength(), s.fromHasTrailingEOL(diffs.getLines1()));
                    continue;
                }
                Hunk h2 = s.getHunk();
                if (h2.isDelete() || h2.isChange()) {
                    this.writeLines("-", diffs.getLines1(), s.getFromStart(), s.getFromLength(), s.fromHasTrailingEOL(diffs.getLines1()));
                }
                if (!h2.isAdd() && !h2.isChange()) continue;
                this.writeLines("+", diffs.getLines2(), s.getToStart(), s.getToLength(), s.toHasTrailingEOL(diffs.getLines2()));
            }
        }
    }

    private String rangeString(int start, int len) {
        if (len > 1) {
            return start + "," + len;
        }
        return Integer.toString(start);
    }

    private void writeDiffHeader(FileHistory hist, FileRevision rev1, FileRevision rev2) throws IOException {
        Path path = hist.getPath();
        String indexPath = this.getIndexPath(hist, rev1, rev2);
        this.out.write("Index: " + indexPath + "\n");
        this.out.write("===================================================================\n");
        if (this.mCRep.getRepositoryType().equals("cvs")) {
            CachedCvsRepository cvsrep = (CachedCvsRepository)this.mCRep;
            this.out.write("RCS file: " + cvsrep.getFilesystemFileForPath(path) + "\n");
        }
        boolean r1Null = rev1 == null;
        boolean r2Null = rev2 == null;
        this.out.write("diff " + this.mOpts.toDiffOptsString());
        if (!r1Null && !r2Null) {
            this.out.write(" -r" + rev1.getRevision() + " -r" + rev2.getRevision());
        }
        this.out.write("\n");
        if (!hist.isBinary()) {
            this.out.write("--- " + this.formatDiffLabel(indexPath, rev1, rev2) + "\n");
            this.out.write("+++ " + this.formatDiffLabel(indexPath, rev2, rev1) + "\n");
        }
    }

    private String getIndexPath(FileHistory hist, FileRevision rev1, FileRevision rev2) throws IOException {
        if (this.mCRep.getRepositoryType().equals("cvs")) {
            return hist.getPath().toString();
        }
        Path path1 = null;
        Path path2 = null;
        if (rev1 != null) {
            path1 = rev1.getPath();
            path2 = rev1.getPath();
        }
        if (rev2 != null) {
            path2 = rev2.getPath();
            if (path1 == null) {
                path1 = rev2.getPath();
            }
        }
        if (path1 == null || path2 == null) {
            path2 = path1 = hist.getPath();
        }
        Path comboPath = new Path(path2.getParent(), path1.getName());
        return comboPath.toString();
    }

    private void writeWholeFile(Disposer disposer, boolean adding, FileRevision rev1) throws IOException, DbException {
        String line;
        String prefix;
        File file = File.createTempFile("fisheye", null);
        disposer.deleteFileOnDispose(file);
        IndexedLineReader lineReader = RevisionContentsUtil.getUnicodeTextRevision(this.mCRep, rev1, file, this.mOpts.kOpt, null);
        disposer.add(lineReader);
        lineReader.scanRestOfFile();
        lineReader.seekLine(0);
        int nlines = lineReader.getTotalLines();
        if (adding) {
            prefix = "+";
            this.out.write("@@ -0,0 +1");
            if (nlines > 1) {
                this.out.write("," + nlines);
            }
            this.out.write(" @@\n");
        } else {
            prefix = "-";
            this.out.write("@@ -1");
            if (nlines > 1) {
                this.out.write("," + nlines);
            }
            this.out.write(" +0,0 @@\n");
        }
        while (null != (line = lineReader.readline())) {
            this.out.write(prefix);
            this.out.write(line);
        }
        if (!lineReader.isEolTerminated()) {
            this.out.write("\n\\ No newline at end of file\n");
        }
    }

    private void writeLines(String prefix, IndexedLineReader lines, int start, int length, boolean hasEol) throws IOException {
        for (int l = start; l < start + length; ++l) {
            this.out.write(prefix);
            lines.seekLine(l);
            this.out.write(lines.readline());
        }
        if (!hasEol) {
            this.out.write("\n\\ No newline at end of file\n");
        }
    }

    private String formatDiffLabel(String rpath, FileRevision rev, FileRevision otherRev) {
        if (this.mCRep.getRepositoryType().equals("cvs")) {
            return this.formatCVSDiffLabel(rpath, rev);
        }
        return this.formatSvnDiffLabel(rpath, rev, otherRev);
    }

    private String formatSvnDiffLabel(String rpath, FileRevision rev, FileRevision otherRev) {
        StringBuffer s = new StringBuffer();
        if (rev == null) {
            s.append(rpath).append("\t(revision 0)");
        } else {
            int[] time = DateHelper.timeToComponents(rev.getDate());
            s.append(rpath).append('\t');
            if (otherRev != null) {
                s.append("(.../");
                Path path = rev.getPath();
                Path otherPath = otherRev.getPath();
                Path relativePath = path.getRelativePath(otherPath.getParent(), this.mCRep.isCaseSensitive());
                if (relativePath.isAbove()) {
                    ArrayList<String> components = new ArrayList<String>(Arrays.asList(relativePath.getComponents()));
                    while (((String)components.get(0)).equals("..")) {
                        components.remove(0);
                    }
                    relativePath = new Path(components);
                }
                s.append(relativePath);
                s.append(")\t");
            }
            s.append("(revision ");
            s.append(rev.getRevision());
            s.append(')');
        }
        return s.toString();
    }

    private String formatCVSDiffLabel(String rpath, FileRevision rev) {
        if (rev == null) {
            return "/dev/null\t1 Jan 1970 00:00:00 -0000";
        }
        int[] time = DateHelper.timeToComponents(rev.getDate());
        StringBuffer s = new StringBuffer();
        s.append(rpath).append('\t');
        StringUtil.pad(s, time[2], 1);
        s.append(' ');
        s.append(RFC822_MONTH_NAMES[time[1] - 1]);
        s.append(' ');
        StringUtil.pad(s, time[0], 1);
        s.append(' ');
        StringUtil.pad(s, time[3], 2);
        s.append(':');
        StringUtil.pad(s, time[4], 2);
        s.append(':');
        StringUtil.pad(s, time[5], 2);
        s.append(" -0000");
        s.append('\t').append(rev.getRevision());
        return s.toString();
    }

    public static class PatchOptions {
        public int linesOfContext = 3;
        public String kOpt = null;
        public boolean absentAsEmpty = false;
        public LineComparator ignore = null;

        public String toDiffOptsString() {
            StringBuffer s = new StringBuffer();
            s.append("-u ");
            if (this.kOpt != null) {
                s.append("-k ").append(this.kOpt).append(" ");
            }
            if (this.absentAsEmpty) {
                s.append("-N ");
            }
            if (this.ignore != null) {
                s.append("-").append(this.ignore.toDiffOptsString()).append(" ");
            }
            return s.toString().trim();
        }
    }
}

