/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;

public class ExpressionUtil {
    private static HashMap COMPILED_REGEXPS = new HashMap();

    public static String urlEncode(Object s) {
        if (s == null) {
            return "";
        }
        try {
            return FishEyeURLEncoder.encode(s.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.warn((Object)"unexpected error encoding url", (Throwable)e2);
            return s.toString();
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long cast2int(Number n) {
        if (n == null) {
            return 0L;
        }
        return n.longValue();
    }

    public static Iterator stringIterator(Object str) {
        if (str == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        final String s = str.toString();
        return new Iterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < s.length();
            }

            public Object next() {
                char c2 = s.charAt(this.i);
                ++this.i;
                return Character.toString(c2);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Object aref(Object list, int index) {
        List l = ExpressionUtil.asList(list);
        if (list == null) {
            return null;
        }
        return l.get(index);
    }

    public static List asList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Collection) {
            return new ArrayList((Collection)o);
        }
        if (o.getClass().isArray()) {
            Object[] array;
            if (o.getClass().getComponentType().isPrimitive()) {
                array = new Object[Array.getLength(o)];
                for (int i2 = 0; i2 < array.length; ++i2) {
                    array[i2] = Array.get(o, i2);
                }
            } else {
                array = (Object[])o;
            }
            return Arrays.asList(array);
        }
        return null;
    }

    public static Collection asCollection(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o.getClass().isArray()) {
            Object[] array;
            if (o.getClass().getComponentType().isPrimitive()) {
                array = new Object[Array.getLength(o)];
                for (int i2 = 0; i2 < array.length; ++i2) {
                    array[i2] = Array.get(o, i2);
                }
            } else {
                array = (Object[])o;
            }
            return Arrays.asList(array);
        }
        return null;
    }

    public static boolean contains(Object collection, Object o) {
        Collection c2 = ExpressionUtil.asCollection(collection);
        if (c2 == null) {
            return false;
        }
        return c2.contains(o);
    }

    public static int computeLength(Object list) {
        if (list == null) {
            return 0;
        }
        if (list instanceof Collection) {
            return ((Collection)list).size();
        }
        if (list.getClass().isArray()) {
            return Array.getLength(list);
        }
        if (list instanceof CharSequence) {
            return ((CharSequence)list).length();
        }
        return 0;
    }

    public static ValueExpression parseExpression(PageContext pageContext, String expr, Class desiredType) {
        JspApplicationContext jspac = JspFactory.getDefaultFactory().getJspApplicationContext(pageContext.getServletContext());
        ExpressionFactory ee = jspac.getExpressionFactory();
        return ee.createValueExpression(pageContext.getELContext(), expr, desiredType);
    }

    public static void escapeString(CharSequence s, Writer w, int start, int len) throws IOException {
        if (s == null) {
            return;
        }
        for (int i2 = start; i2 < start + len; ++i2) {
            char c2 = s.charAt(i2);
            ExpressionUtil.escapeChar(c2, w);
        }
    }

    public static void escapeString(CharSequence s, Writer w) throws IOException {
        if (s == null) {
            return;
        }
        ExpressionUtil.escapeString(s, w, 0, s.length());
    }

    public static String escapeString(CharSequence s) {
        StringWriter out = new StringWriter();
        try {
            ExpressionUtil.escapeString(s, out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static void escapeChar(char c2, Writer w) throws IOException {
        if (c2 == '&') {
            w.write("&amp;");
        } else if (c2 == '<') {
            w.write("&lt;");
        } else if (c2 == '>') {
            w.write("&gt;");
        } else if (c2 == '\"') {
            w.write("&#034;");
        } else if (c2 == '\'') {
            w.write("&#039;");
        } else if (c2 > '\u0080') {
            w.write("&#" + c2 + ";");
        } else {
            w.write(c2);
        }
    }

    public static Path[] abbreviatePathComponents(Path path, int maxLen) {
        return path.abbreviatePathComponents(maxLen);
    }

    public static Object sessionValue(PageContext page, String key) {
        ServletRequest request = page.getRequest();
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(key);
    }

    public static boolean rematch(String re, String input) {
        Pattern p;
        WeakReference wr = (WeakReference)COMPILED_REGEXPS.get(re);
        Pattern pattern = p = wr == null ? null : (Pattern)wr.get();
        if (p == null) {
            p = Pattern.compile(re);
            COMPILED_REGEXPS.put(re, new WeakReference<Pattern>(p));
        }
        return p.matcher(input).matches();
    }

    public static List repositories(HttpServletRequest request) {
        return RepositoryUtil.repositories(request);
    }

    public static String pluralise(String singular, String plural, int count) {
        return count != 1 ? plural : singular;
    }
}

