/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class FormatDateTag
extends TagSupport {
    private Date mValue = null;
    private String mTimeZone = null;
    private String mPattern = "";

    public void setValue(Date value) {
        this.mValue = value;
    }

    public void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
    }

    public void setPattern(String pattern) {
        this.mPattern = pattern;
    }

    public int doEndTag() throws JspException {
        try {
            SimpleDateFormat format;
            try {
                format = new SimpleDateFormat(this.mPattern, Locale.US);
            }
            catch (IllegalArgumentException e2) {
                Logs.APP_LOG.warn((Object)("internal error: date format wrong " + this.mPattern), (Throwable)e2);
                return 6;
            }
            TimeZone tz = null;
            if (this.mTimeZone == null || "".equals(this.mTimeZone)) {
                UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser((HttpServletRequest)this.pageContext.getRequest());
                if (user != null) {
                    try {
                        UserProfile up = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                        String preferedTZ = up.getEffectiveTimezone();
                        if (preferedTZ != null) {
                            tz = TimeZone.getTimeZone(preferedTZ);
                        }
                    }
                    catch (DbException e3) {
                        // empty catch block
                    }
                }
                if (tz == null) {
                    tz = AppConfig.getsConfig().getTimezone();
                }
            } else {
                tz = TimeZone.getTimeZone(this.mTimeZone);
            }
            format.setTimeZone(tz);
            String result = this.mValue == null ? "" : format.format(this.mValue);
            ExpressionUtil.escapeString(result, (Writer)this.pageContext.getOut());
            return 6;
        }
        catch (IOException e4) {
            throw new JspException((Throwable)e4);
        }
    }
}

