/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.TxTemplate;
import com.atlassian.crucible.spi.rpc.RpcAuthHelper;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpcSecurityInterceptor")
public class RpcSecurityInterceptor
implements MethodInterceptor {
    @Autowired
    private RpcAuthHelper authHelper;
    @Autowired
    private TxTemplate txTemplate;
    private static Set unsecuredMethods = new HashSet<String>(Arrays.asList("getContext", "setContext"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        try {
            if (!unsecuredMethods.contains(methodInvocation.getMethod().getName())) {
                if (methodInvocation.getArguments().length < 1 || !(methodInvocation.getArguments()[0] instanceof String)) {
                    throw new IllegalArgumentException("The method " + methodInvocation.getThis().getClass().getName() + "." + methodInvocation.getMethod().getName() + " does not have a String as its first parameter.");
                }
                String token = (String)methodInvocation.getArguments()[0];
                Principal user = this.authHelper.checkToken(token);
                if (user == null) {
                    user = this.authHelper.authenticateFromRequest();
                }
                if (user == null) {
                    RootConfig root = AppConfig.getsConfig();
                    if (!root.getConfig().getSecurity().getAllowAnon() || !root.getConfig().getSecurity().getAllowCruAnon()) {
                        throw new SecurityException("Anonymous access is not allowed.");
                    }
                    user = Principal.Anonymous.ANON;
                }
                this.txTemplate.setEffectivePrincipal(user);
            }
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            this.txTemplate.setEffectivePrincipal(null);
        }
    }
}

