/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.atlassian.crucible.spi.TxTemplate;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.opensymphony.xwork.ActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.exception.GenericJDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAction
extends ActionSupport {
    protected CrucibleUserManager userManager;
    private TxHelper txHelper;
    private List<CrucibleUser> userCache;
    private List<CrucibleUser> activeUserCache;
    protected ProjectManager projectManager;
    protected TxTemplate txTemplate;
    private WebResourceManager webResourceManager;
    private List<Project> projects;

    public BaseAction() {
        this.setAttribute("this", (Object)this);
        this.userManager = new CrucibleUserManager();
        this.txHelper = new TxHelper();
        this.setAttribute("currentuser", this.getCurrentUser());
    }

    public void setTxTemplate(TxTemplate txTemplate) {
        this.txTemplate = txTemplate;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public CookiePreferences getUserPreferences() {
        return PreferenceManager.getPreferences(CrucibleFilter.getRequest());
    }

    public RepositoryManager getRepositoryManager() {
        return AppConfig.getsConfig().getRepositoryManager();
    }

    public void setAttribute(String name, Object attrib) {
        CrucibleFilter.getRequest().setAttribute(name, attrib);
    }

    public Object getAttribute(String name) {
        return CrucibleFilter.getRequest().getAttribute(name);
    }

    public String getParameter(String name) {
        return CrucibleFilter.getRequest().getParameter(name);
    }

    public Principal getPrincipal() {
        return CrucibleFilter.getCurrentPrincipal();
    }

    public CrucibleUser getCurrentUser() {
        return CrucibleFilter.getCurrentUser();
    }

    public Collection getUserNames() throws DbException {
        return this.userManager.getUserNames();
    }

    public List<CrucibleUser> getUsers() throws DbException {
        if (this.userCache == null) {
            this.userCache = this.userManager.getUsers();
        }
        return this.userCache;
    }

    public List<CrucibleUser> getActiveUsers() throws DbException {
        if (this.activeUserCache == null) {
            this.activeUserCache = this.userManager.getActiveUsers();
        }
        return this.activeUserCache;
    }

    protected void beginTx() {
        this.txHelper.beginTx();
    }

    protected void commitTx() {
        try {
            this.txHelper.commitTx();
        }
        catch (GenericJDBCException e2) {
            Logs.APP_LOG.error((Object)e2);
            throw e2;
        }
    }

    protected void rollbackTxIfNotCommited() {
        this.txHelper.rollbackTxIfNotCommited();
    }

    public List getRepositories() {
        return RepositoryUtil.repositories(CrucibleFilter.getRequest());
    }

    public RepositoryHandle getDefaultRepo() {
        List repos = this.getRepositories();
        for (Object repo1 : repos) {
            RepositoryHandle repo = (RepositoryHandle)repo1;
            if (!repo.isRunning()) continue;
            return repo;
        }
        return null;
    }

    public String getCookedRSSNoteURL() throws DbException {
        LoginCookie cookie = AppConfig.getsConfig().getUserManager().preCookUrl(CrucibleFilter.getRequest(), "/cru/rss", true);
        return cookie == null ? "" : cookie.encode();
    }

    public List<Project> getProjectList() {
        if (this.projects == null) {
            this.projects = this.projectManager.getAllProjects();
        }
        return this.projects;
    }

    public List<Project> getProjectsCanCreateIn() {
        List<Project> projects = this.projectManager.getAllProjects();
        ArrayList<Project> results = new ArrayList<Project>();
        for (Project project : projects) {
            if (!ReviewUtil.principalCanDoProjectAction(this.getPrincipal(), "action:createReview", project)) continue;
            results.add(project);
        }
        return results;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }
}

