/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DownloadPatchAction
extends ReviewBaseAction {
    private static final Pattern ACTION_PATH_PROG = Pattern.compile("^/?(\\d+).*");
    private String actionPathInfo;
    private String errorMsg = "Can't find files referenced by ";
    private String contentType = "text/plain";
    private InputStream inputStream;

    public void setActionPathInfo(String path) {
        this.actionPathInfo = path;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        try {
            this.beginTx();
            String result = this.doDownload();
            this.commitTx();
            String string = result;
            return string;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Problem getting patch", (Throwable)e2);
            this.errorMsg = "Problem getting patch: " + e2.getMessage();
            String string = "error";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private String doDownload() throws IOException {
        Matcher m = ACTION_PATH_PROG.matcher(this.actionPathInfo);
        if (m.matches()) {
            int patchid = Integer.parseInt(m.group(1));
            return this.setupPatchDownload(patchid);
        }
        this.errorMsg = "Patch id not specified";
        return "error";
    }

    private String setupPatchDownload(int patchid) throws IOException {
        Patch patch = PatchManager.getPatchById(patchid);
        if (patch == null) {
            this.errorMsg = "No such patch " + patchid;
            return "error";
        }
        UploadItem item = patch.getUploadItem();
        this.inputStream = new BufferedInputStream(new FileInputStream(item.getItemFile()));
        if (item.getOriginalContentType() != null) {
            this.contentType = item.getOriginalContentType();
        }
        return "success";
    }

    public String getError() {
        return "error.general";
    }

    public String getErrorDescription() {
        return this.errorMsg;
    }
}

