/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import java.util.List;
import org.springframework.transaction.TransactionStatus;

public class DeletePermSchemeAction
extends BaseAction {
    private String psName;

    public void setName(String psName) {
        this.psName = psName;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme ps = PermissionManager.findPS(DeletePermSchemeAction.this.psName);
                if (ps == null) {
                    DeletePermSchemeAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                List<Project> projects = PermissionManager.getProjectsUsingPermScheme(ps);
                if (!projects.isEmpty()) {
                    DeletePermSchemeAction.this.addActionError("This Permission Scheme is used by some projects.");
                    return "error";
                }
                PermissionManager.deletePermissionScheme(ps);
                return "success";
            }
        });
    }
}

