/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.project;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.admin.project.AbstractProjectFormAction;
import com.cenqua.crucible.actions.admin.project.ProjectData;
import com.cenqua.crucible.actions.admin.project.ProjectDataFactory;
import com.cenqua.crucible.model.Project;
import org.springframework.transaction.TransactionStatus;

public class ProjectOperationAction
extends AbstractProjectFormAction {
    private String op;
    private String id = null;
    private ProjectData project;
    private ProjectDataFactory projectDataFactory;

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                if ("Edit".equals(ProjectOperationAction.this.op)) {
                    ProjectOperationAction.this.project = ProjectOperationAction.this.projectDataFactory.createFromProject(ProjectOperationAction.this.getProject());
                    return "success";
                }
                if ("Delete".equals(ProjectOperationAction.this.op)) {
                    Project p = ProjectOperationAction.this.getProject();
                    if (ProjectOperationAction.this.projectManager.getDefaultProject().equals(p)) {
                        ProjectOperationAction.this.addActionError("Default Project can't be deleted.");
                        return "error";
                    }
                    if (ProjectOperationAction.this.projectManager.deleteProject(p)) {
                        return "list";
                    }
                    ProjectOperationAction.this.addActionError("Project can't be deleted, it still has reviews.");
                    return "error";
                }
                throw new RuntimeException("Unrecognised operation " + ProjectOperationAction.this.op);
            }
        });
    }

    private Project getProject() {
        try {
            int idInt = Integer.parseInt(this.id);
            return this.projectManager.getProjectById(idInt);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(this.id + " is not a valid integer", nfe);
        }
    }

    public ProjectData getProjectData() {
        return this.project;
    }

    public void setProjectDataFactory(ProjectDataFactory projectDataFactory) {
        this.projectDataFactory = projectDataFactory;
    }
}

