/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.comment;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.comment.BaseCommentAction;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.notification.NotificationManager;

public class ReplyAjaxAction
extends BaseCommentAction
implements AjaxResponse {
    private Integer replyToId;
    private Comment reply;

    public Integer getReplyToId() {
        return this.replyToId;
    }

    public void setReplyToId(Integer replyToId) {
        this.replyToId = replyToId;
    }

    public Comment getReply() {
        return this.reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            this.beginTx();
            if (!this.isAllowed()) {
                this.commitTx();
                this.setErrorMsg("Sorry you're not authorized to add a reply to this comment.");
                String string = "error";
                return string;
            }
            this.reply = this.makeComment();
            if (this.reply == null) {
                this.commitTx();
                String string = "error";
                return string;
            }
            Comment comment = CommentManager.getById(this.replyToId);
            if (comment == null) {
                this.commitTx();
                this.setErrorMsg("Can't find the comment you are replying to, it may have been deleted.");
                String string = "error";
                return string;
            }
            if (comment.isDeleted()) {
                this.commitTx();
                this.setErrorMsg("Sorry this comment has been deleted. (Please reload the page for updates)");
                String string = "error";
                return string;
            }
            this.reply.setReplyToComment(comment);
            comment.addComment(this.reply);
            if (!this.reply.isDraft()) {
                NotificationManager.INSTANCE.noteReplied(this.getReview(), comment, this.reply);
            }
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

