/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateReviewFromChangesetAction
extends BaseAction {
    public static final int MAX_TITLE_LENGTH = 60;
    private Review review;
    private String requestedRepo;
    private String title;
    private String description;
    private String[] csid;
    private Map<String, ReviewCreationHelper> createHelpers = new HashMap<String, ReviewCreationHelper>();
    private Project project;
    private static final Pattern CSID_PATTERN = Pattern.compile("^(//([^/]+)/)?(.+)$");

    public void setProjectId(int projectId) {
        this.project = this.projectManager.getProjectById(projectId);
    }

    public String getActionName() {
        return "create";
    }

    public Project getProject() {
        return this.project;
    }

    public void setProjectKey(String projectKey) {
        this.project = this.projectManager.getProjectByKey(projectKey);
    }

    public String getProjectKey() {
        return this.project == null ? null : this.project.getKey();
    }

    public String getPermaId() {
        return this.review == null ? "" : this.review.getPermaId();
    }

    public void setRepo(String repo) {
        this.requestedRepo = repo;
    }

    public void setCsid(String[] csid) {
        this.csid = csid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            List<Project> principlesProjects;
            this.beginTx();
            if (this.getCurrentUser() == null) {
                this.commitTx();
                String string = "loginRequired";
                return string;
            }
            if (this.project == null) {
                principlesProjects = this.getProjectsCanCreateIn();
                if (principlesProjects.size() == 1) {
                    this.project = principlesProjects.get(0);
                } else {
                    List<Project> candidateProjects = this.filterProjectsByRepo(principlesProjects);
                    if (candidateProjects.size() > 0) {
                        this.project = candidateProjects.get(0);
                    }
                    if (candidateProjects.size() != 1) {
                        this.commitTx();
                        String string = "selectProject";
                        return string;
                    }
                }
            }
            if (!ReviewUtil.principalCanDoProjectAction(this.getPrincipal(), "action:createReview", this.project)) {
                this.addActionError("You do not have permission to create reviews in project " + this.project.getName());
                principlesProjects = "selectProject";
                return principlesProjects;
            }
            this.review = ReviewManager.createReviewWithDefaults(this.projectManager, this.project, "");
            if (this.review.getModerator() == null) {
                this.review.setModerator(this.getCurrentUser());
            }
            this.review.setCreator(this.getCurrentUser());
            ArrayList<ChangeSet> addedChangesets = new ArrayList<ChangeSet>();
            String newestRepo = null;
            long dateOfNewestRepo = 0L;
            for (String id : this.csid) {
                String cs;
                String currentRepo;
                Matcher m = CSID_PATTERN.matcher(id);
                if (!m.matches()) continue;
                if (m.group(2) != null) {
                    currentRepo = m.group(2);
                    cs = m.group(3);
                } else {
                    currentRepo = this.requestedRepo;
                    cs = m.group(3);
                }
                ChangeSet changeset = this.addToReview(currentRepo, cs);
                if (changeset == null) continue;
                addedChangesets.add(changeset);
                if (dateOfNewestRepo >= changeset.getDate()) continue;
                newestRepo = currentRepo;
                dateOfNewestRepo = changeset.getDate();
            }
            Collections.sort(addedChangesets, new NewestFirstComparator());
            ChangeSet newestChangeset = null;
            if (!addedChangesets.isEmpty()) {
                newestChangeset = (ChangeSet)addedChangesets.get(0);
            }
            if (!StringUtil.nullOrEmpty(this.requestedRepo)) {
                this.review.setRepoName(this.requestedRepo);
            } else {
                this.review.setRepoName(newestRepo);
            }
            if (!StringUtil.nullOrEmpty(this.title)) {
                this.review.setName(this.title);
            } else if (newestChangeset != null) {
                this.review.setName(StringUtil.firstLineOf(newestChangeset.getComment(), 60, false, true, true));
            }
            if (!StringUtil.nullOrEmpty(this.description)) {
                this.review.setDescription(this.description);
            } else {
                this.review.setDescription(this.summariseDescriptions(addedChangesets));
            }
            CrucibleUser changesetAuthor = null;
            if (newestChangeset != null) {
                changesetAuthor = CrucibleUserManager.getUserByName(newestChangeset.getAuthor());
            }
            this.review.setAuthor(changesetAuthor != null ? changesetAuthor : this.getCurrentUser());
            this.commitTx();
            Logs.APP_LOG.debug((Object)("Created review " + this.review.getPermaId()));
            String string = "done";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private List<Project> filterProjectsByRepo(List<Project> projects) {
        if (StringUtil.nullOrEmpty(this.requestedRepo)) {
            return projects;
        }
        ArrayList<Project> filtered = new ArrayList<Project>();
        for (Project p : projects) {
            if (!this.requestedRepo.equals(p.getDefaultRepositoryName())) continue;
            filtered.add(p);
        }
        return filtered;
    }

    private String summariseDescriptions(List<ChangeSet> orderedChangesets) {
        if (orderedChangesets.isEmpty()) {
            return "";
        }
        StringBuffer summary = orderedChangesets.size() > 1 ? new StringBuffer("Generated from changeset comments:\n") : new StringBuffer();
        String sep = "";
        for (ChangeSet cs : orderedChangesets) {
            summary.append(sep);
            String trimmedComment = cs.getComment() == null ? "" : cs.getComment().trim();
            summary.append(cs.getId()).append(": ");
            if (trimmedComment.contains("\n")) {
                summary.append("\n");
            }
            summary.append(trimmedComment);
            sep = "\n";
        }
        return summary.toString();
    }

    private ChangeSet addToReview(String repo, String cs) throws SourceException, FileRevisionException, RepositoryHandle.StateException, DbException {
        ReviewCreationHelper ch = this.getCreateHelper(repo);
        if (ch != null) {
            return ch.addChangeSet(this.getCurrentUser(), cs, true);
        }
        Logs.APP_LOG.warn((Object)("Could not create ReviewCreationHelper for repo '" + repo + "', not adding changeset '" + cs + "' to review."));
        return null;
    }

    private ReviewCreationHelper getCreateHelper(String repo) throws SourceException {
        ReviewCreationHelper helper = this.createHelpers.get(repo);
        if (helper == null) {
            Source s = CrucibleFilter.getSource(Source.getRepoSourceName(repo));
            if (!s.isAvailable()) {
                this.addActionMessage("Repository " + repo + " is not available. Cannot add changeset to review.");
            }
            if (s instanceof RepositorySource) {
                helper = new ReviewCreationHelper((RepositorySource)s, this.review);
                this.createHelpers.put(repo, helper);
            } else {
                throw new SourceException("RepositorySource required to add changeset");
            }
        }
        return helper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NewestFirstComparator
    implements Comparator<ChangeSet> {
        private NewestFirstComparator() {
        }

        @Override
        public int compare(ChangeSet o1, ChangeSet o2) {
            if (o1.getDate() > o2.getDate()) {
                return -1;
            }
            if (o1.getDate() == o2.getDate()) {
                return 0;
            }
            return 1;
        }
    }
}

