/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.hibernate.AuditInterceptor;
import com.cenqua.crucible.hibernate.Config;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.fisheye.logging.Logs;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static final ThreadLocal<Session> threadSession = new ThreadLocal();
    private static final ThreadLocal<Transaction> threadTransaction = new ThreadLocal();
    private static final Object LOCK = new Object();
    private static SessionFactory sessionFactory;
    private static Configuration cfg;
    private static volatile boolean isRunning;
    private static final Set<Session> sessions;

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp() throws CruDBException {
        Object object = LOCK;
        synchronized (object) {
            if (!isRunning) {
                HibernateUtil.setUp(null);
                isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp(Properties feprops) throws CruDBException {
        Object object = LOCK;
        synchronized (object) {
            try {
                cfg = Config.configDB(feprops);
                sessionFactory = cfg.buildSessionFactory();
                isRunning = true;
            }
            catch (Throwable ex) {
                Logs.APP_LOG.error((Object)"Crucible Database setup failed.", ex);
                throw new CruDBException(ex);
            }
        }
    }

    public static boolean isRunning() {
        return isRunning;
    }

    private static void shutdownHSQLDB() throws SQLException, ClassNotFoundException {
        if (cfg != null) {
            Connection conn = Config.getConnection(cfg);
            Statement st = conn.createStatement();
            st.execute("SHUTDOWN");
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean anySessionsActive() {
        Object object = LOCK;
        synchronized (object) {
            return !sessions.isEmpty();
        }
    }

    public static boolean isCurrentSession() {
        return threadSession.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session currentSession() throws HibernateException {
        Session s = threadSession.get();
        if (s == null) {
            Object object = LOCK;
            synchronized (object) {
                if (!HibernateUtil.isRunning()) {
                    throw new HibernateException("Hibernate has been shutdown");
                }
                AuditInterceptor i2 = new AuditInterceptor();
                s = sessionFactory.openSession((Interceptor)i2);
                i2.setSession(s);
                threadSession.set(s);
                sessions.add(s);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession() throws HibernateException {
        Session s = threadSession.get();
        if (s != null) {
            s.close();
            Object object = LOCK;
            synchronized (object) {
                sessions.remove(s);
            }
        }
        threadSession.set(null);
    }

    public static void beginTransaction() {
        Transaction tx = threadTransaction.get();
        if (tx == null) {
            tx = HibernateUtil.currentSession().beginTransaction();
            threadTransaction.set(tx);
        }
    }

    public static void commitTransaction() {
        Transaction tx = threadTransaction.get();
        try {
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.commit();
            }
        }
        catch (HibernateException he) {
            for (int i2 = 0; i2 < he.getMessages().length; ++i2) {
                String s = he.getMessages()[i2];
                Logs.APP_LOG.error((Object)("Commit fail msg-" + i2 + ":" + s));
            }
            Logs.APP_LOG.error((Object)"Commit failed rolling back.", (Throwable)he);
            HibernateUtil.rollbackTransaction();
            throw he;
        }
        finally {
            threadTransaction.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollbackTransaction() {
        Transaction tx = threadTransaction.get();
        try {
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.rollback();
            }
        }
        finally {
            threadTransaction.set(null);
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroy() {
        isRunning = false;
        Logs.APP_LOG.info((Object)"Shutting down Crucible DB.");
        long closePauseTime = 500L;
        long closeAttemptTimeout = 20000L;
        long stopTryingAt = System.currentTimeMillis() + 20000L;
        while (HibernateUtil.anySessionsActive()) {
            if (System.currentTimeMillis() > stopTryingAt) {
                Logs.APP_LOG.error((Object)("Timed out waiting on " + sessions.size() + " sessions to close, forcing shutdown"));
                break;
            }
            Logs.APP_LOG.info((Object)("Stopping Crucible DB, waiting for " + sessions.size() + " sessions to close."));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
                break;
            }
        }
        Object object = LOCK;
        synchronized (object) {
            try {
                HibernateUtil.shutdownHSQLDB();
            }
            catch (SQLException e2) {
                Logs.APP_LOG.warn((Object)"Unexpected problem shutting down HSQLDB", (Throwable)e2);
            }
            catch (ClassNotFoundException e3) {
                Logs.APP_LOG.warn((Object)"Unexpected problem shutting down HSQLDB", (Throwable)e3);
            }
            finally {
                if (sessionFactory != null) {
                    sessionFactory.close();
                    sessionFactory = null;
                }
                cfg = null;
                isRunning = false;
            }
        }
        return true;
    }

    static {
        isRunning = false;
        sessions = new HashSet<Session>();
    }
}

