/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.model.AuthorizationException;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CommonListMixin;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Review
extends CommonListMixin
implements CommentList,
CustomFieldList {
    private Integer id;
    private String reviewName = "no name";
    private String repoName;
    private String state = "Unknown";
    private State stateOb = null;
    private String description;
    private String summary;
    private Date createDate;
    private Integer metricsVersion;
    private CrucibleUser creator = null;
    private Set<ReviewParticipant> participants = new HashSet<ReviewParticipant>();
    private Review parentReview;
    private List<FileRevisionExtraInfo> frxs = new LinkedList<FileRevisionExtraInfo>();
    private boolean allowReviewerToJoin = false;
    private Project project;
    private Set<ReviewPermaId> permaIds = new HashSet<ReviewPermaId>();
    private ProjectManager projectManager;
    private static final String DEFAULT_PRECIS_TEMPLATE = "review-precis-plain.ftl";
    public CrucibleUser CachedAuthor = null;
    public CrucibleUser CachedModerator = null;

    public Review() {
        this.setCreateDate(new Date());
    }

    public Review(ProjectManager projectManager, Project project, String name) {
        this.projectManager = projectManager;
        this.project = project;
        this.addPermaId(projectManager, project);
        this.setName(name);
        State firstState = StateManager.INSTANCE.getFirstState();
        this.setState(firstState);
        this.setCreateDate(new Date());
    }

    public Set<ReviewPermaId> getPermaIdHistory() {
        return this.permaIds;
    }

    public void setPermaIdHistory(Set<ReviewPermaId> permaId) {
        this.permaIds = permaId;
    }

    private void addPermaId(ProjectManager projectManager, Project project) {
        this.getPermaIdHistory().add(new ReviewPermaId(this, project.getKey(), projectManager.getNextSeqNo(project)));
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public Review getParentReview() {
        return this.parentReview;
    }

    public void setParentReview(Review parentReview) {
        this.parentReview = parentReview;
    }

    public List getChildReviews() {
        return ReviewManager.getReviewChildren(this);
    }

    public String getPermaId() {
        for (ReviewPermaId permaId : this.permaIds) {
            if (!permaId.getPermaIdKey().key.equals(this.getProject().getKey())) continue;
            return permaId.toString();
        }
        return "CR-" + this.getId();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean isAllowReviewerToJoin() {
        return this.allowReviewerToJoin;
    }

    public void setAllowReviewerToJoin(boolean allowReviewerToJoin) {
        this.allowReviewerToJoin = allowReviewerToJoin;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getClosedDate() {
        List<StateChangeLog> changes = this.getStateChanges();
        for (StateChangeLog changeLog : changes) {
            if (!changeLog.getNewState().equals("Closed")) continue;
            return changeLog.getTimeStamp();
        }
        return null;
    }

    public String getName() {
        return this.reviewName;
    }

    public void setName(String name) {
        this.reviewName = name;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String name) {
        this.repoName = name;
    }

    public String getStateName() {
        return this.getState().getName();
    }

    public State getState() {
        if (this.stateOb == null) {
            this.stateOb = StateManager.INSTANCE.getStateByName(this.state);
        }
        return this.stateOb;
    }

    public void setStateName(String state) {
        this.state = state;
        this.stateOb = null;
    }

    public void setState(State state) {
        this.state = state.getName();
        this.stateOb = state;
    }

    @Override
    public Integer getMetricsVersion() {
        return this.metricsVersion;
    }

    public void setMetricsVersion(Integer metricsVersion) {
        this.metricsVersion = metricsVersion;
    }

    @Override
    public HashMap getFieldDefinitions() {
        if (this.getMetricsVersion() != null) {
            return MetricsManager.INSTANCE.getConfig(this.getMetricsVersion()).getReviewFields();
        }
        return new HashMap();
    }

    public void changeState(String action, CrucibleUser user) throws Exception {
        StateTransition st;
        if (ReviewUtil.canDoReviewAction(action, this)) {
            st = this.getState().getTransition(action);
            if (st == null) {
                throw new AuthorizationException("You can't do " + action + " in state " + this.getState().getName());
            }
        } else {
            throw new AuthorizationException("Crucible unauthorised action.");
        }
        st.processScripts(user, this);
        this.setState(st.getNextState());
        NotificationManager.INSTANCE.noteStateChange(this, user);
        LogManager.logStateChange(this.getState().toString(), this.getId());
        LogManager.log(this.getPermaId() + ": " + this.getName() + ", user " + user.getDisplayName() + ", did " + action + ". Changed to state: " + this.getState());
        this.getState().processEntryScripts(user, this);
    }

    public List<FileRevision> getAllReviewFileRevisions() {
        return Collections.unmodifiableList(FRXManager.getFileRevisions(this));
    }

    public FileRevisionExtraInfo getFRExtraInfo(FileRevision fr) {
        return FRXManager.getFRExtraInfo(fr, this);
    }

    public List<StateChangeLog> getStateChanges() {
        return LogManager.getStateChanges(this.getId(), false);
    }

    public boolean isCreator(CrucibleUser user) {
        return this.getCreator() != null && this.getCreator().equals(user);
    }

    public boolean isAuthor(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        return p != null && p.isAuthor();
    }

    public boolean isModerator(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        return p != null && p.isModerator();
    }

    public boolean isReviewer(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        return p != null && p.isReviewer();
    }

    public CrucibleUser getCreator() {
        return this.creator;
    }

    public void setCreator(CrucibleUser creator) {
        this.creator = creator;
    }

    private Set<ReviewParticipant> getParticipants() {
        return this.participants;
    }

    private void setParticipants(Set<ReviewParticipant> participants) {
        this.participants = participants;
    }

    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getDefaultProject();
        }
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void changeProject(Project project) throws DbException {
        this.setProject(project);
        this.addPermaId(this.getProjectManager(), project);
        Set<CrucibleUser> allowedReviewers = project.getAllowedReviewers();
        if (!allowedReviewers.contains(this.getModerator()) && project.getDefaultModerator() != null) {
            this.setModerator(project.getDefaultModerator());
        }
        this.setAllowReviewerToJoin(project.isAllowReviewersToJoin());
        if (!allowedReviewers.isEmpty()) {
            Set<CrucibleUser> currentReviewers = this.getReviewers();
            for (CrucibleUser cu : currentReviewers) {
                if (allowedReviewers.contains(cu)) continue;
                this.removeReviewer(cu);
            }
        }
        if (this.getReviewers().isEmpty()) {
            Set<CrucibleUser> defaultReviewers = project.getDefaultReviewers();
            for (CrucibleUser cu : defaultReviewers) {
                this.addReviewer(cu);
            }
        }
    }

    public void setAuthor(CrucibleUser user) {
        ReviewParticipant oldAuth = this.getAuthorP();
        if (oldAuth != null) {
            if (!oldAuth.isModerator()) {
                this.removeParticipant(oldAuth);
            } else {
                oldAuth.setAuthor(false);
            }
        }
        ReviewParticipant p = ParticipantManager.createParticipant(this, user);
        p.setAuthor(true);
        this.participants.add(p);
        this.CachedAuthor = user;
    }

    public ReviewParticipant getAuthorP() {
        for (ReviewParticipant p : this.participants) {
            if (!p.isAuthor()) continue;
            return p;
        }
        return null;
    }

    public CrucibleUser getAuthor() {
        ReviewParticipant p;
        if (this.CachedAuthor == null && (p = this.getAuthorP()) != null) {
            this.CachedAuthor = p.getUser();
        }
        return this.CachedAuthor;
    }

    public void setModerator(CrucibleUser user) {
        ReviewParticipant oldMod = this.getModeratorP();
        if (oldMod != null) {
            if (!oldMod.isAuthor()) {
                this.removeParticipant(oldMod);
            } else {
                oldMod.setModerator(false);
            }
        }
        ReviewParticipant p = ParticipantManager.createParticipant(this, user);
        p.setModerator(true);
        this.participants.add(p);
        this.CachedModerator = user;
    }

    public ReviewParticipant getModeratorP() {
        for (ReviewParticipant p : this.participants) {
            if (!p.isModerator()) continue;
            return p;
        }
        return null;
    }

    public CrucibleUser getModerator() {
        ReviewParticipant p;
        if (this.CachedModerator == null && (p = this.getModeratorP()) != null) {
            this.CachedModerator = p.getUser();
        }
        return this.CachedModerator;
    }

    public void addReviewer(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.createParticipant(this, user);
        if (p.isAuthor() || p.isModerator()) {
            return;
        }
        p.setReviewer(true);
        this.participants.add(p);
    }

    public void removeParticipant(ReviewParticipant p) {
        if (p != null) {
            this.participants.remove(p);
            ParticipantManager.deleteParticipant(p);
        }
    }

    public void removeParticipant(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        this.removeParticipant(p);
    }

    public void removeReviewer(CrucibleUser user) {
        this.removeParticipant(user);
    }

    public Set<CrucibleUser> getActiveReviewers() {
        HashSet<CrucibleUser> active = new HashSet<CrucibleUser>();
        for (ReviewParticipant p : this.participants) {
            if (!p.isReviewer() || p.isAllComplete()) continue;
            active.add(p.getUser());
        }
        return active;
    }

    public Set<ReviewParticipant> getTeam() {
        return Collections.unmodifiableSet(this.participants);
    }

    public Set<CrucibleUser> getReviewers() {
        HashSet<CrucibleUser> reviewer = new HashSet<CrucibleUser>();
        for (ReviewParticipant p : this.participants) {
            if (!p.isReviewer()) continue;
            reviewer.add(p.getUser());
        }
        return reviewer;
    }

    public int getCountActiveReviewers() {
        return this.getActiveReviewers().size();
    }

    public Set<CrucibleUser> getCompletedReviewers() {
        HashSet<CrucibleUser> completed = new HashSet<CrucibleUser>();
        for (ReviewParticipant p : this.participants) {
            if (!p.isReviewer() || !p.isAllComplete()) continue;
            completed.add(p.getUser());
        }
        return completed;
    }

    public int getCountCompletedReviewers() {
        return this.getCompletedReviewers().size();
    }

    public boolean setReviewerComplete(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        if (p == null) {
            return false;
        }
        p.setAllComplete(true);
        if (this.getActiveReviewers().isEmpty()) {
            NotificationManager.INSTANCE.noteAllComplete(this, user);
        } else {
            NotificationManager.INSTANCE.noteReviewerComplete(this, user);
        }
        LogManager.log(this.getPermaId() + ": " + user.getDisplayName() + " completed review.");
        return true;
    }

    public void setReviewerIncomplete(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        if (p != null) {
            p.setAllComplete(false);
        }
        if (this.getActiveReviewers().size() == 1) {
            NotificationManager.INSTANCE.noteAllNoLongerComplete(this, user);
        } else {
            NotificationManager.INSTANCE.noteReviewerIncomplete(this, user);
        }
    }

    public LinkedList<Role> getUsersRoles(CrucibleUser user) {
        LinkedList<Role> result = new LinkedList<Role>();
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        if (p != null) {
            if (p.isModerator()) {
                result.add(ReviewManager.MODERATOR);
            }
            if (p.isAuthor()) {
                result.add(ReviewManager.AUTHOR);
            }
            if (p.isReviewer()) {
                result.add(ReviewManager.REVIEWER);
            }
        }
        if (this.creator.equals(user)) {
            result.add(ReviewManager.CREATOR);
        }
        return result;
    }

    public Set<CrucibleUser> getUsersFromRoles(List roles) {
        HashSet<CrucibleUser> users = new HashSet<CrucibleUser>();
        if (roles.contains(ReviewManager.AUTHOR)) {
            users.add(this.getAuthor());
        }
        if (roles.contains(ReviewManager.MODERATOR)) {
            users.add(this.getModerator());
        }
        if (roles.contains(ReviewManager.CREATOR)) {
            users.add(this.getCreator());
        }
        if (roles.contains(ReviewManager.REVIEWER)) {
            users.addAll(this.getReviewers());
        }
        return users;
    }

    public boolean checkWriteAccess(CrucibleUser user) {
        return !this.getState().isClosedMetaState() && (ParticipantManager.getByUser(this, user) != null || this.getCreator().equals(user));
    }

    public boolean checkActiveReviewer(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        return p != null && !p.isAllComplete();
    }

    public boolean checkCompletedReviewer(CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(this, user);
        return p != null && p.isAllComplete();
    }

    public List<FileRevision> getFileRevisions() {
        return FRXManager.getFileRevisions(this);
    }

    public List<FileRevisionExtraInfo> getFrxs() {
        return this.frxs;
    }

    public void setFrxs(List<FileRevisionExtraInfo> frxs) {
        this.frxs = frxs;
    }

    public FileRevisionExtraInfo addFileRevision(FileRevision fr) {
        return FRXManager.createAndAddFRX(fr, this);
    }

    public synchronized boolean removeFileRevision(FileRevision fr) {
        FileRevisionExtraInfo frx = FRXManager.getFRExtraInfo(fr, this);
        return frx != null && this.removeFRX(frx);
    }

    public synchronized boolean removeFRX(FileRevisionExtraInfo frx) {
        if (!this.getState().isDraftState() && !frx.getRevisionComments().isEmpty()) {
            return false;
        }
        if (!this.getState().isDraftState()) {
            frx.getRevisionComments().clear();
        }
        return this.frxs.remove(frx);
    }

    public HashMap getRevisionCommentStats() {
        HashSet<Comment> revisionComments = new HashSet<Comment>();
        revisionComments.addAll(CommentManager.getRevisionCommentComments(this));
        return this.commentListImpl.getCommentStats(revisionComments);
    }

    public int getRevisionCommentCount() {
        return CommentManager.getReviewFrxsCommentCount(this, null, false, false, null);
    }

    public Collection<Comment> getRevisionCommentComments() {
        return CommentManager.getRevisionCommentComments(this);
    }

    public int getCountAllCommentsInReview() {
        return this.getCommentCount() + this.getRevisionCommentCount();
    }

    public String toString() {
        String superStr = super.toString();
        return this.getPermaId() + ": " + superStr;
    }

    public String getPrecis() {
        HashMap<String, Review> root = new HashMap<String, Review>();
        root.put("review", this);
        StringWriter writer = new StringWriter();
        try {
            Template precisTemplate = this.getTemplate(DEFAULT_PRECIS_TEMPLATE);
            precisTemplate.process(root, (Writer)writer);
            writer.flush();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Exception processing review precis template 'review-precis-plain.ftl'", (Throwable)e2);
        }
        return writer.toString();
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "cru/" + this.getPermaId() + "/review";
    }

    public void cleanupAllComments() {
        this.cleanupAllComments(null);
    }

    public void cleanupAllComments(CrucibleUser user) {
        this.cleanUpComments(user);
        for (FileRevisionExtraInfo frx : this.frxs) {
            frx.cleanUpRevisionComments(user);
        }
    }

    protected Template getTemplate(String filename) throws IOException {
        return AppConfig.getsConfig().getTemplateConfig().getTemplate(filename);
    }

    private ProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = (ProjectManager)SpringContext.getComponent("projectManager");
        }
        return this.projectManager;
    }

    public boolean isDescendantOf(Review parent) {
        return this != parent && this.isUnseenDescendantOf(parent, new HashSet<Integer>());
    }

    private boolean isUnseenDescendantOf(Review parent, Set<Integer> seenReviews) {
        if (this.getParentReview() == null) {
            return false;
        }
        seenReviews.add(this.getParentReview().getId());
        return seenReviews.contains(parent.getId()) || this.getParentReview().isUnseenDescendantOf(parent, seenReviews);
    }
}

