/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.RevisionComment;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class RevisionCommentManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static RevisionComment createAndAddRevisionComment(Comment comment, FileRevisionExtraInfo frx, FileRevision revision) {
        RevisionComment rc = RevisionCommentManager.getRevisionComment(comment, revision);
        if (rc != null) {
            return rc;
        }
        rc = new RevisionComment(frx);
        rc.setComment(comment);
        rc.setRevision(revision);
        rc.setCreateDate(new Date());
        frx.addRevisionComment(rc);
        RevisionCommentManager.session().save((Object)rc);
        return rc;
    }

    public static RevisionComment getById(Integer id) {
        return (RevisionComment)RevisionCommentManager.session().get(RevisionComment.class, (Serializable)id);
    }

    private static RevisionComment getRevisionComment(Comment comment, FileRevision revision) {
        Query q = RevisionCommentManager.session().createQuery("select rc from RevisionComment rc where rc.comment = :comment and rc.revision = :revision");
        q.setEntity("comment", (Object)comment);
        q.setEntity("revision", (Object)revision);
        return (RevisionComment)q.uniqueResult();
    }

    public static List getRevisionComments() {
        return RevisionCommentManager.session().createQuery("from RevisionComment").list();
    }

    public static void deleteRevisionComment(RevisionComment rc) {
        RevisionCommentManager.session().delete((Object)rc);
    }
}

