/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.fisheye.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffMatcher {
    private static final String HEADER_PATH_MATCH = "/*?([^\\t]*)";
    private static final String HEADER_REV_MATCH = "(?:\\t\\(?(revision )?([^\\n^\\)]*)?\\)?)?";
    protected static final Pattern FROM_HEADER_PROG = Pattern.compile("^[-]{3} /*?([^\\t]*)(?:\\t\\(?(revision )?([^\\n^\\)]*)?\\)?)?");
    protected static final Pattern TO_HEADER_PROG = Pattern.compile("^[+]{3} /*?([^\\t]*)(?:\\t\\(?(revision )?([^\\n^\\)]*)?\\)?)?");
    protected static final Pattern NULL_REVISION_PROG = Pattern.compile("dev/null");
    protected static final Pattern SECTION_PROG = Pattern.compile("@@\\s-(\\d+),?(\\d+)?\\s\\+(\\d+),?(\\d+)?\\s@@");

    protected Matcher findMatch(Pattern pat, String string) {
        Matcher m = pat.matcher(string);
        if (m.find()) {
            return m;
        }
        return null;
    }

    protected Header matchHeader(boolean from, String line) {
        Matcher m = this.findMatch(from ? FROM_HEADER_PROG : TO_HEADER_PROG, line);
        if (m == null) {
            return null;
        }
        return new Header(m);
    }

    protected Section matchSection(String line) {
        Matcher m = this.findMatch(SECTION_PROG, line);
        if (m == null) {
            return null;
        }
        return new Section(m);
    }

    class Section {
        Matcher m;

        Section(Matcher m) {
            this.m = m;
        }

        public String getFromLine() {
            return this.m.group(1);
        }

        public String getNumberFromLines() {
            return this.m.group(2);
        }

        public String getToLine() {
            return this.m.group(3);
        }

        public String getNumberToLines() {
            return this.m.group(4);
        }
    }

    class Header {
        Matcher m;

        Header(Matcher m) {
            this.m = m;
        }

        public String getPath() {
            return this.m.group(1);
        }

        public String getRevision() {
            return this.isNullRev() ? null : (StringUtil.nullOrEmpty(this.m.group(3)) ? "(no revision)" : this.m.group(3));
        }

        public boolean isNullRev() {
            Matcher mn = NULL_REVISION_PROG.matcher(this.getPath());
            return mn.find() || "0".equals(this.m.group(3));
        }
    }
}

