/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.cenqua.crucible.fisheye.FakeFishEyeFileRevision;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.revision.FileInfo;
import com.cenqua.crucible.revision.PatchFileInfo;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchDiff;
import com.cenqua.crucible.revision.diff.patchDiff.PatchSectionView;
import com.cenqua.crucible.revision.source.PatchFRXDO;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.RegionList;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchSource
extends Source {
    private Map<Integer, PatchDiff> patchDiffCache = new HashMap<Integer, PatchDiff>();

    public PatchSource(String sourceName) {
        this.sourceName = sourceName;
    }

    public PatchDiff getDiff(FileRevisionExtraInfo frx) {
        return this.getDiff(frx.getFileRevision());
    }

    public PatchDiff getDiff(FileRevision fileRevision) {
        if (!this.patchDiffCache.containsKey(fileRevision.getId())) {
            this.patchDiffCache.put(fileRevision.getId(), new PatchDiff(fileRevision));
        }
        return this.patchDiffCache.get(fileRevision.getId());
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isAnySuccessorRevisions(FileRevision fr) {
        return false;
    }

    public String getLatestRevIdent(FileRevision fr) {
        return fr.getRevIdent();
    }

    public String getChangeSetId(FileRevision fileRevision) {
        Patch p = PatchManager.findPatch(fileRevision);
        return p == null ? null : p.getId().toString();
    }

    public FileInfo getFileInfo(FileRevision fileRevision) {
        return new PatchFileInfo(fileRevision, this.getDiff(fileRevision));
    }

    public static FileRevision makeFromRevision(Patch p, DiffRevisionsInfo dri) {
        return FileRevisionManager.createRevision("PATCH:" + p.getId(), dri.getPath().getPath(), dri.getIndex() + ":F", dri.getFromRevisionName(), new Date());
    }

    public static FileRevision makeToRevision(Patch p, DiffRevisionsInfo dri) {
        return FileRevisionManager.createRevision("PATCH:" + p.getId(), dri.getPath().getPath(), dri.getIndex() + ":T", dri.getToRevisionName(), new Date());
    }

    public DiffPrinter getDiffPrinter(FileRevisionExtraInfo frx, String keywordOpts, String diffOpts, int context, boolean sideBySide, boolean softWrap) throws Exception {
        return new DiffPrinter(this.getDiff(frx).getSectionViews(), sideBySide, softWrap);
    }

    public FRXDO getFRXDO(FileRevisionExtraInfo frx, CrucibleUser currentUser, String keywordOpts, boolean sideBySide, boolean softWrap) throws Exception {
        Patch p = PatchManager.findPatch(frx.getFileRevision());
        DiffRevisionsInfo dri = p.getDiffRevisionInfo(frx.getFileRevision());
        if (dri != null) {
            return new PatchFRXDO(dri, frx, currentUser, keywordOpts, sideBySide, softWrap);
        }
        throw new Exception("Could not diff revisions, DiffRevisionInfo is null.");
    }

    public Blame getBlame(FileRevision toRevision) throws Exception {
        PatchDiff diff = this.getDiff(toRevision);
        List<PatchSectionView> sects = diff.getSectionViews();
        if (sects.size() != 1) {
            throw new Exception("Could not get blame for file.");
        }
        PatchSectionView view = sects.get(0);
        FakeFishEyeFileRevision fakefr = new FakeFishEyeFileRevision(toRevision, this.getFileInfo(toRevision));
        ArrayList<Blame.BlameChunk> chunks = new ArrayList<Blame.BlameChunk>();
        for (int line = 0; line < view.getSection().getToLength(); ++line) {
            Blame.BlameChunk chunk = new Blame.BlameChunk(fakefr, line, line);
            chunks.add(chunk);
        }
        return new Blame(chunks);
    }

    public IndexedLineReader getFileContents(FileRevision toRev, File tmpFile, String kopts) throws Exception {
        PatchDiff diff = this.getDiff(toRev);
        List<PatchSectionView> sects = diff.getSectionViews();
        if (sects.size() != 1) {
            throw new Exception("Could not get contents for file.");
        }
        PatchSectionView view = sects.get(0);
        IOHelper.copyCharSequenceToFile(view.getToLines(), tmpFile);
        return new IndexedLineReader(tmpFile);
    }

    public void insertLinks(CharSequence charSequence, RegionList regions) {
        Linker linker = AppConfig.getsConfig().getDefaultLinker();
        linker.insertLinks(charSequence, regions);
    }
}

