/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.BucketDataElement;
import com.cenqua.fisheye.rep.DbException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketData
implements Iterable<Map.Entry<Integer, BucketDataElement>> {
    private TreeMap<Integer, BucketDataElement> data = new TreeMap();

    public BucketData() {
    }

    public BucketData(Integer bucket, int linecount, int revcount) {
        this.add(bucket, linecount, revcount);
    }

    public int size() {
        return this.data.size();
    }

    public boolean hasBucket(int bucket) {
        return this.data.containsKey(bucket);
    }

    public BucketDataElement getBucketData(int bucket) {
        return this.data.get(bucket);
    }

    public void add(Integer bucket, int linecount, int revcount) throws NullPointerException {
        BucketDataElement dataElement = this.getBucketData(bucket);
        if (dataElement == null) {
            dataElement = new BucketDataElement(linecount, revcount);
        } else {
            dataElement.add(linecount, revcount);
        }
        this.data.put(bucket, dataElement);
    }

    public String toString() {
        return this.data.toString();
    }

    public void addAllValues(BucketData newData) throws DbException {
        for (Map.Entry<Integer, BucketDataElement> element : newData) {
            this.add(element.getKey(), element.getValue().getLinecount(), element.getValue().getRevcount());
        }
    }

    @Override
    public Iterator<Map.Entry<Integer, BucketDataElement>> iterator() {
        return this.data.entrySet().iterator();
    }

    public int getFirstBucket() {
        return this.data.firstKey();
    }

    public int getLastBucket() {
        return this.data.lastKey();
    }

    public Integer[] getBucketNames() {
        Integer[] bucketNames = new Integer[this.size()];
        this.data.keySet().toArray(bucketNames);
        return bucketNames;
    }

    public Integer getTotalAtBucket(int bucket) {
        int total = 0;
        for (Map.Entry<Integer, BucketDataElement> dataElement : this.data.entrySet()) {
            if (dataElement.getKey() > bucket) {
                return total;
            }
            total += dataElement.getValue().getLinecount();
        }
        return total;
    }

    public BucketData copy() {
        BucketData copy = new BucketData();
        for (Map.Entry<Integer, BucketDataElement> entry : this.data.entrySet()) {
            copy.add(entry.getKey(), entry.getValue().getLinecount(), entry.getValue().getRevcount());
        }
        return copy;
    }
}

