/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.BucketData;
import com.cenqua.fisheye.bucket.Period;
import com.cenqua.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.bucket.RenamingRules;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketDataCollection
implements Iterable<Map.Entry<String, BucketData>> {
    private final Map<String, BucketData> data = new HashMap<String, BucketData>();

    public void add(String key, BucketData value) throws DbException {
        BucketData bucketData = this.get(key);
        if (bucketData == null) {
            this.data.put(key, value);
        } else {
            bucketData.addAllValues(value);
            this.data.put(key, bucketData);
        }
    }

    public void add(BucketDataCollection collection) throws DbException {
        for (Map.Entry<String, BucketData> item : collection) {
            this.add(item.getKey(), item.getValue());
        }
    }

    @Override
    public Iterator<Map.Entry<String, BucketData>> iterator() {
        return this.data.entrySet().iterator();
    }

    public BucketData get(String key) {
        return this.data.get(key);
    }

    public void add(String key, int bucket, int linecount, int revcount) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, new BucketData());
        }
        this.data.get(key).add(bucket, linecount, revcount);
    }

    public int getFirstBucket() {
        int min = Integer.MAX_VALUE;
        for (BucketData bucketData : this.data.values()) {
            min = Math.min(min, bucketData.getFirstBucket());
        }
        return min;
    }

    public int getLastBucket() {
        int max = Integer.MIN_VALUE;
        for (BucketData bucketData : this.data.values()) {
            max = Math.max(max, bucketData.getLastBucket());
        }
        return max;
    }

    public String toString() {
        return this.data.toString();
    }

    public int collectionCount() {
        return this.data.size();
    }

    public List<Pair<String, BucketData>> consolidateAndSort(Date dateEnd, PeriodUnit periodSlurp, PeriodUnit periodGraph, TimeZone timeZone, int maxElements, RenamingRules renameRules) throws DbException {
        if (renameRules != null) {
            for (Pair<String, List<String>> rule : renameRules) {
                BucketData tmpData = new BucketData();
                for (String s : rule.getSecond()) {
                    if (!this.data.containsKey(s)) continue;
                    tmpData.addAllValues(this.data.get(s));
                    this.data.remove(s);
                }
                if (tmpData.size() == 0) continue;
                this.data.put(rule.getFirst(), tmpData);
            }
        }
        ArrayList<Pair<String, Integer>> lastVals = new ArrayList<Pair<String, Integer>>();
        ArrayList<Pair<String, BucketData>> newData = new ArrayList<Pair<String, BucketData>>();
        Period lastPeriodGraph = new Period(periodGraph, dateEnd, timeZone);
        Period lastPeriodSlurp = new Period(periodSlurp, lastPeriodGraph.getEndDate(), timeZone);
        for (Map.Entry<String, BucketData> data : this) {
            if (data.getKey().equals("__ALL_AUTHORS__") || data.getKey().equals("__ALL_EXTENSIONS__")) continue;
            lastVals.add(new Pair<String, Integer>(data.getKey(), data.getValue().getTotalAtBucket(lastPeriodSlurp.getBucket())));
        }
        Collections.sort(lastVals, new Comparator<Pair<String, Integer>>(){

            @Override
            public int compare(Pair<String, Integer> a2, Pair<String, Integer> b2) {
                int absA = Math.abs(a2.getSecond());
                int absB = Math.abs(b2.getSecond());
                int stringComp = a2.getFirst().compareToIgnoreCase(b2.getFirst());
                if (absA != absB) {
                    return -(absA - absB);
                }
                return stringComp;
            }
        });
        int numNotOther = lastVals.size() == maxElements ? maxElements : Math.min(maxElements - 1, lastVals.size());
        for (int i2 = 0; i2 < numNotOther; ++i2) {
            String key = (String)((Pair)lastVals.get(i2)).getFirst();
            newData.add(new Pair<String, BucketData>(key, this.data.get(key)));
        }
        if (lastVals.size() > maxElements) {
            BucketData otherData = new BucketData();
            for (int i3 = numNotOther; i3 < lastVals.size(); ++i3) {
                String key = (String)((Pair)lastVals.get(i3)).getFirst();
                otherData.addAllValues(this.data.get(key));
            }
            newData.add(new Pair<String, BucketData>("Other", otherData));
        }
        return newData;
    }

    public void renameKey(String newName) {
        if (this.data.keySet().size() == 1) {
            for (String oldKey : this.data.keySet()) {
                BucketData bucketData = this.data.get(oldKey);
                this.data.remove(oldKey);
                this.data.put(newName, bucketData);
            }
        }
    }

    public BucketData getFirst() {
        Iterator<BucketData> i$ = this.data.values().iterator();
        if (i$.hasNext()) {
            BucketData s = i$.next();
            return s;
        }
        return null;
    }

    public BucketDataCollection copy() throws DbException {
        BucketDataCollection copy = new BucketDataCollection();
        for (Map.Entry<String, BucketData> entry : this.data.entrySet()) {
            copy.add(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }
}

