/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.ExtnCollector;
import com.cenqua.fisheye.bucket.InfinityDBConnector;
import com.cenqua.fisheye.bucket.InsertIterator;
import com.cenqua.fisheye.bucket.ParameterSet;
import com.cenqua.fisheye.bucket.ParameterSetInsert;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.bucket.SumCollector;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4uide._Attribute;
import com.cenqua.obfuscate.idbk4uide._Cu;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Dir {
    private static final int SUBDIR_CACHE_MIN_DEPTH = -1;
    private static int SUBDIR_CACHE_MAX_DEPTH = 5;
    private int ID = -1;
    private final InfinityDBConnector con;
    private static final _Attribute schemaID = CommonSchema.A_NEXT_ID_DIR;

    private Dir(InfinityDBConnector con) throws DbException {
        this.con = con;
        this.ID = con.getNextIdAndIncrement(schemaID, 1);
    }

    Dir(int ID, InfinityDBConnector con) throws DbException {
        this.con = con;
        this.setID(ID);
    }

    private void setID(int ID) throws DbException {
        this.ID = ID;
        this.con.saveNextId(schemaID, ID + 1);
    }

    static void setCacheDepth(int depth) {
        SUBDIR_CACHE_MAX_DEPTH = -1 + depth;
    }

    static int getCacheDepth() {
        return SUBDIR_CACHE_MAX_DEPTH - -1;
    }

    private static boolean useSubtotalCache(int depth) {
        return depth >= -1 && depth < SUBDIR_CACHE_MAX_DEPTH;
    }

    public void getAvailableExtns(ParameterSet params, int depth, ExtnCollector collection) throws DbException {
        switch (params.getPosition(depth)) {
            case BeforeLast: {
                if (this.hasSubdir(params.getPath(depth + 1))) {
                    collection.addRecursion(this.loadSubdir(params.getPath(depth + 1)), params, depth + 1);
                    break;
                }
                Logs.APP_LOG.debug((Object)("Subdir \"" + params.getPath(depth + 1) + "\" of dir " + params.getPathToDepth(depth) + "not present in LOC data: only " + this.getSubdirIDs().keySet()));
                break;
            }
            case AtLast: 
            case AfterLast: {
                if (this.getDataID() > -1) {
                    collection.add(this.con.getAvailableExtns(this.getDataID(), CommonSchema.A_DATA));
                }
                if (Dir.useSubtotalCache(depth)) {
                    collection.add(this.con.getAvailableExtns(this.getCacheID(), CommonSchema.A_CACHE));
                    break;
                }
                for (String subdir : this.getSubdirIDs().keySet()) {
                    collection.addRecursion(this.loadSubdir(subdir), params, depth + 1);
                }
                break;
            }
        }
    }

    void getBuckets(ParameterSetRetrieve parameters, int depth, SumCollector sum) throws DbException {
        switch (parameters.getPosition(depth)) {
            case BeforeLast: {
                if (this.hasSubdir(parameters.getPath(depth + 1))) {
                    sum.addRecursion(this.loadSubdir(parameters.getPath(depth + 1)), parameters, depth + 1);
                    break;
                }
                Logs.APP_LOG.debug((Object)("Subdir \"" + parameters.getPath(depth + 1) + "\" of dir " + parameters.getPathToDepth(depth) + "not present in LOC data: only " + this.getSubdirIDs().keySet()));
                break;
            }
            case AtLast: 
            case AfterLast: {
                if (parameters.breakdown == ParameterSetRetrieve.BreakdownOption.SUBDIR) {
                    for (String subdir : this.getSubdirIDs().keySet()) {
                        sum.addRecursion(this.loadSubdir(subdir), parameters, depth + 1, subdir);
                    }
                } else {
                    if (this.getDataID() > -1) {
                        sum.add(this.con.getBuckets(this.getDataID(), parameters, CommonSchema.A_DATA));
                    }
                    if (Dir.useSubtotalCache(depth)) {
                        sum.add(this.con.getBuckets(this.getCacheID(), parameters, CommonSchema.A_CACHE));
                        break;
                    }
                    for (String subdir : this.getSubdirIDs().keySet()) {
                        sum.addRecursion(this.loadSubdir(subdir), parameters, depth + 1);
                    }
                }
                break;
            }
        }
    }

    void getBuckets(ParameterSetRetrieve parameters, int depth, SumCollector sum, String key) throws DbException {
        if (this.getDataID() > -1) {
            if (depth == parameters.path.numComponents()) {
                sum.add(this.con.getBuckets(this.getDataID(), parameters, ". (this dir)", CommonSchema.A_DATA));
            } else {
                sum.add(this.con.getBuckets(this.getDataID(), parameters, key, CommonSchema.A_DATA));
            }
        }
        if (Dir.useSubtotalCache(depth)) {
            sum.add(this.con.getBuckets(this.getCacheID(), parameters, key, CommonSchema.A_CACHE));
        } else {
            for (String subdir : this.getSubdirIDs().keySet()) {
                sum.addRecursion(this.loadSubdir(subdir), parameters, depth + 1, key);
            }
        }
    }

    void insertNewChild(ParameterSetInsert parameters, int depth, InsertIterator it) throws DbException {
        if (parameters.getPosition(depth) != ParameterSet.Position.AfterLast) {
            Dir newChild = new Dir(this.con);
            this.addSubdir(parameters.getPath(depth), newChild);
            switch (parameters.getPosition(depth)) {
                case AtLast: {
                    newChild.addToData(parameters);
                    break;
                }
                case BeforeLast: {
                    if (Dir.useSubtotalCache(depth)) {
                        newChild.addToCache(parameters);
                    }
                    it.addRecursion(newChild, parameters, depth + 1, true);
                }
            }
        }
    }

    void insertData(ParameterSetInsert parameters, int depth, InsertIterator it) throws DbException {
        switch (parameters.getPosition(depth)) {
            case AtLast: {
                this.addToData(parameters);
                break;
            }
            case BeforeLast: {
                if (Dir.useSubtotalCache(depth)) {
                    this.addToCache(parameters);
                }
                if (this.hasSubdir(parameters.getPath(depth + 1))) {
                    it.addRecursion(parameters.loadSubdir(this, depth), parameters, depth + 1, false);
                    break;
                }
                it.addRecursion(this, parameters, depth + 1, true);
            }
        }
    }

    String toStringFull() throws DbException {
        StringBuffer buffer = new StringBuffer();
        this.toStringNodes("", buffer);
        return buffer.toString();
    }

    private void toStringNodes(String prefix, StringBuffer buffer) throws DbException {
        prefix = prefix + "(Dir " + this.ID + ") ";
        this.con.dataToString(this.getDataID(), prefix + "data ", buffer, CommonSchema.A_DATA);
        this.con.dataToString(this.getCacheID(), prefix + "cache ", buffer, CommonSchema.A_CACHE);
        for (Map.Entry<String, Integer> element : this.getSubdirIDs().entrySet()) {
            Dir subdir = new Dir(element.getValue(), this.con);
            subdir.toStringNodes(prefix + element.getKey(), buffer);
        }
    }

    Dir loadSubdir(String key) throws DbException {
        return new Dir(this.getSubdirIDs().get(key), this.con);
    }

    private void addToData(ParameterSetInsert parameters) throws DbException {
        int oldID = this.getDataID();
        int dataID = this.con.addToData(this.getDataID(), parameters, CommonSchema.A_DATA);
        if (dataID != oldID) {
            this.saveDataID(dataID);
        }
    }

    private void addToCache(ParameterSetInsert parameters) throws DbException {
        int oldID = this.getCacheID();
        int cacheID = this.con.addToData(this.getCacheID(), parameters, CommonSchema.A_CACHE);
        if (cacheID != oldID) {
            this.saveCacheID(cacheID);
        }
    }

    private void addSubdir(String key, Dir dir) throws DbException {
        this.con.saveSubdirID(this.ID, key, dir.ID);
    }

    public String toString() {
        try {
            return "DirInfDB " + this.ID + ": dataID " + this.getDataID() + ", cacheID " + this.getCacheID() + ", subDirIDs " + this.getSubdirIDs();
        }
        catch (DbException e2) {
            e2.printStackTrace();
            return "";
        }
    }

    void commit() throws DbException {
        this.con.commitDB();
    }

    private int getDataID() throws DbException {
        return this.con.loadDirAttribute(this.ID, CommonSchema.A_DATA_ID, _Cu.alloc());
    }

    private int getCacheID() throws DbException {
        return this.con.loadDirAttribute(this.ID, CommonSchema.A_CACHE_ID, _Cu.alloc());
    }

    private void saveCacheID(int id) throws DbException {
        this.con.saveDirAttribute(this.ID, CommonSchema.A_CACHE_ID, id);
    }

    private void saveDataID(int id) throws DbException {
        this.con.saveDirAttribute(this.ID, CommonSchema.A_DATA_ID, id);
    }

    Map<String, Integer> getSubdirIDs() throws DbException {
        return this.con.loadSubdirIDs(this.ID);
    }

    boolean hasSubdir(String subdir) throws DbException {
        return this.con.loadSubdirID(this.ID, subdir) != -1;
    }

    String loadTimeZone() throws DbException {
        return this.con.loadTimeZone();
    }

    InfinityDBConnector getConnector() {
        return this.con;
    }
}

