/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.ctl.BaseCommand;
import com.cenqua.fisheye.ctl.InstanceLock;
import com.cenqua.fisheye.ctl.NativeLibrarySetup;
import com.cenqua.fisheye.ctl.ShutdownService;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.WebServer;
import com.cenqua.fisheye.web.util.InetAddrPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mortbay.util.MultiException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class Run
extends BaseCommand {
    private static final List earlyLog = new LinkedList();

    public static void main(String[] args) {
        int rc = Run.mainImpl(args);
        if (rc != 0) {
            System.exit(rc);
        }
    }

    public static int mainImpl(String[] args) {
        WebServer ws;
        ShutdownService shutdown;
        InstanceLock lock;
        Run.initJVM();
        Run.setupLogging(false);
        if (AppConfig.isCrucible()) {
            // empty if block
        }
        if ((lock = InstanceLock.acquireLock()) == null) {
            Logs.APP_LOG.error((Object)"Another instance of FishEye seems to be running");
            return 1;
        }
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (!Run.handleCommonArguments(argList, System.err)) {
            return 1;
        }
        Run.sysinfo();
        NativeLibrarySetup.setup();
        RootConfig rootConfig = AppConfig.getsConfig();
        if (AppConfig.getConfigurationFile().isFile()) {
            try {
                rootConfig.load(AppConfig.getConfigurationFile());
            }
            catch (IOException e2) {
                System.err.println("Problem reading config file: " + e2.getMessage());
                Logs.APP_LOG.info((Object)"IOE", (Throwable)e2);
                return 1;
            }
            catch (ConfigException e3) {
                System.err.println("Problem with config file: " + e3.getMessage());
                Logs.APP_LOG.info((Object)"CE", (Throwable)e3);
                return 1;
            }
        }
        String sid = rootConfig.getConfig().getLicense().getSID();
        if (!rootConfig.getAdminConfig().haveDoneInitialSetup()) {
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"=======================================================");
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"Welcome to FishEye!");
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"You need to configure an admin password and enter your");
            Logs.CONSOLE.info((Object)"license key. You can do this by accessing FishEye through");
            Logs.CONSOLE.info((Object)"a web browser:");
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"http://hostipaddress:8060/");
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"Alternatively you can edit config.xml, refer to the");
            Logs.CONSOLE.info((Object)"FishEye administration guide for more infotmation:");
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"http://confluence.atlassian.com/x/N4CDBQ");
            Logs.CONSOLE.info((Object)"");
            Logs.CONSOLE.info((Object)"=======================================================");
            Logs.CONSOLE.info((Object)"");
        }
        try {
            rootConfig.loadLicense();
        }
        catch (LicenseException e4) {
            System.err.println(e4.getMessage());
            if (rootConfig.getLicense() != null && rootConfig.getLicense().isMaintenanceExpired()) {
                System.err.println("Please visit http://www.atlassian.com/fisheye/renew and quote " + sid + " to obtain a valid license.");
            } else {
                System.err.println(" Please visit http://my.atlassian.com and quote " + sid + " to obtain a valid license.");
            }
            Logs.APP_LOG.info((Object)"LE", (Throwable)e4);
        }
        LicenseInfo license = rootConfig.getLicense();
        if (license != null) {
            if (license.getFisheyeLicense().getOwnerStatement() != null) {
                Logs.CONSOLE.info((Object)(license.getFisheyeLicense().getOwnerStatement() + " (" + license.getFisheyeLicense().getPublicID() + ")"));
            } else if (license.getCrucibleLicense() != null && license.getCrucibleLicense().getOwnerStatement() != null) {
                Logs.CONSOLE.info((Object)(license.getCrucibleLicense().getOwnerStatement() + " (" + license.getCrucibleLicense().getPublicID() + ")"));
            }
            if (license.isTerminated()) {
                Logs.CONSOLE.info((Object)("Your license has been terminated (" + license.getSoftExpiryValue().toGMTString() + ")."));
                Logs.CONSOLE.info((Object)("Please visit http://my.atlassian.com and quote " + sid + " to obtain a valid license."));
            } else if (license.isExpired()) {
                Logs.CONSOLE.info((Object)("Your license has expired (" + license.getSoftExpiryValue().toGMTString() + ")."));
                Logs.CONSOLE.info((Object)("Please visit http://my.atlassian.com and quote " + sid + " to obtain a valid license."));
            } else if (license.expires()) {
                Logs.CONSOLE.info((Object)("Your license expires in " + DateHelper.age(license.getSoftExpiry(), System.currentTimeMillis())));
            }
        }
        try {
            rootConfig.start();
        }
        catch (IOException e5) {
            System.err.println("Problem reading config file: " + e5.getMessage());
            Logs.APP_LOG.info((Object)"IOE", (Throwable)e5);
            return 1;
        }
        catch (ConfigException e6) {
            System.err.println("Problem with config file: " + e6.getMessage());
            Logs.APP_LOG.info((Object)"CE", (Throwable)e6);
            return 1;
        }
        catch (DbException e7) {
            System.err.println("Problem starting FishEye: " + e7.getMessage());
            Logs.APP_LOG.info((Object)"DBE", (Throwable)e7);
            return 1;
        }
        if (AppConfig.noSlurp) {
            RepositoryManager repositoryManager = rootConfig.getRepositoryManager();
            for (RepositoryHandle rep : repositoryManager.getHandles()) {
                rep.setDisableBackgroundUpdaterOnInit(AppConfig.noSlurp);
            }
        }
        String ctlBind = rootConfig.getControlBind();
        try {
            shutdown = new ShutdownService(new InetAddrPort(ctlBind), lock);
        }
        catch (UnknownHostException e8) {
            Logs.APP_LOG.error((Object)("Unknown host error binding control port: " + e8.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e8);
            return 1;
        }
        AppConfig.setShutdown(shutdown);
        try {
            ws = new WebServer();
        }
        catch (UnknownHostException e9) {
            Logs.APP_LOG.error((Object)("Unknown host error binding web port: " + e9.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e9);
            return 1;
        }
        catch (IOException e10) {
            Logs.APP_LOG.error((Object)("Could not create webserver: " + e10.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e10);
            return 1;
        }
        AppConfig.setWebServer(ws);
        shutdown.setWebServer(ws);
        if (AppConfig.isCrucible()) {
            Logs.CONSOLE.debug((Object)"starting Crucible database...");
            try {
                AppConfig.getCrucibleBridge().startup();
            }
            catch (ConfigException e11) {
                Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e11);
                Run.logStartupException(e11);
                return 1;
            }
        }
        try {
            Logs.CONSOLE.debug((Object)"starting control server...");
            shutdown.start();
        }
        catch (BindException e12) {
            Logs.APP_LOG.error((Object)("Could not bind control port '" + ctlBind + "' :  " + e12.getMessage()));
            return 1;
        }
        catch (Exception e13) {
            Logs.APP_LOG.error((Object)("Could not create control server: " + e13.getMessage()));
            return 1;
        }
        try {
            Logs.CONSOLE.debug((Object)"starting server...");
            ws.start();
            Logs.CONSOLE.info((Object)("Server started on " + ws.getDesc() + " (control port on " + ctlBind + ")"));
        }
        catch (Exception e14) {
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e14);
            Run.logStartupException(e14);
            return 1;
        }
        rootConfig.startRepositories();
        return 0;
    }

    private static void initSpringBootstrap() {
        BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance();
        BeanFactory factory = locator.useBeanFactory("com.atlassian.fisheye.bootstrapContext").getFactory();
    }

    private static void logStartupException(Throwable e2) {
        if (e2 instanceof MultiException) {
            MultiException me = (MultiException)e2;
            for (Throwable ne : me.getThrowables()) {
                Run.logStartupException(ne);
            }
        } else {
            Logs.APP_LOG.error((Object)("Could not start server: " + e2.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initJVM() {
        System.setProperty("com.bluecast.xml.ValidatingSAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        System.setProperty("org.apache.cxf.Logger", "com.cenqua.fisheye.logging.CxfLog4jLogger");
        File f2 = new File(AppConfig.getInstanceDir(), "system.properties");
        if (f2.isFile()) {
            earlyLog.add("Loading custom system.properties " + f2);
            FileInputStream in = null;
            try {
                in = new FileInputStream(f2);
                System.getProperties().load(in);
            }
            catch (Exception e2) {
                try {
                    String msg = "WARN: problem loading custom system properties " + f2 + " : " + e2.getMessage();
                    earlyLog.add(msg);
                    System.err.println(msg);
                    e2.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOHelper.close(in);
                    throw throwable;
                }
                IOHelper.close(in);
            }
            IOHelper.close(in);
        }
    }

    private static void sysinfo() {
        if (AppConfig.isCrucible()) {
            AppConfig.getCrucibleBridge().logSysinfo();
        } else {
            Logs.CONSOLE.info((Object)"FishEye 1.5.4 (build-308), Built on 2008-07-31");
        }
        if (!earlyLog.isEmpty()) {
            for (String msg : earlyLog) {
                Logs.APP_LOG.info((Object)("earlier: " + msg));
            }
            earlyLog.clear();
        }
        long maxmem = Runtime.getRuntime().maxMemory();
        Logs.DEBUG_LOG.info((Object)("Logging started (" + System.getProperty("java.vm.vendor", "-") + "|" + System.getProperty("java.vm.version", "-") + "|" + System.getProperty("java.home", "-") + "|" + System.getProperty("os.name", "-") + "|" + System.getProperty("os.arch", "-") + "|" + System.getProperty("os.version", "-") + "|" + "maxmem=" + (maxmem == Long.MAX_VALUE ? "nolimit" : maxmem / 1024L / 1024L + "MB") + ")"));
    }
}

