/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.ctl.InstanceLock;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.SvnRepositoryEngine;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.FishEyeBackup;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.WebServer;
import com.cenqua.fisheye.web.util.InetAddrPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShutdownService {
    private final InetAddrPort mBind;
    private final InstanceLock mLock;
    private boolean mStopping = false;
    private String mControlKey = "cenqua";
    private static final int FAILURE_CODE = 1;
    private ServerSocket mSvr;
    private WebServer mWS;

    public ShutdownService(InetAddrPort bind, InstanceLock lock) {
        this.mBind = bind;
        this.mLock = lock;
    }

    public void start() throws IOException {
        this.mSvr = new ServerSocket(this.mBind.getPort(), 0, this.mBind.getInetAddress());
        Runnable srvRunner = new Runnable(){

            public void run() {
                ShutdownService.this.runServer();
            }
        };
        Thread srvThread = new Thread(srvRunner, "FishEye Shutdown Service");
        srvThread.setDaemon(true);
        srvThread.start();
    }

    private void runServer() {
        Logs.APP_LOG.info((Object)("listening on " + this.mBind));
        block5: while (true) {
            try {
                while (!this.mStopping) {
                    final Socket socket = this.mSvr.accept();
                    Logs.APP_LOG.debug((Object)("Socket timeout is " + socket.getSoTimeout()));
                    try {
                        Thread commandThread = new Thread(new Runnable(){

                            public void run() {
                                ShutdownService.this.handleClient(socket);
                            }
                        });
                        commandThread.start();
                        continue block5;
                    }
                    catch (RuntimeException e2) {
                        Logs.APP_LOG.error((Object)"unexpected exception", (Throwable)e2);
                    }
                    catch (Error e3) {
                        Logs.APP_LOG.error((Object)"unexpected error", (Throwable)e3);
                    }
                }
                break;
            }
            catch (IOException e4) {
                if (this.mStopping) break;
                Logs.APP_LOG.warn((Object)"shutdown socket disabled", (Throwable)e4);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(Socket socket) {
        block28: {
            try {
                socket.setTcpNoDelay(true);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                OutputStream out = socket.getOutputStream();
                String key = lin.readLine();
                if (!this.mControlKey.equals(key)) {
                    Logs.APP_LOG.warn((Object)("invalid control key from " + socket.getInetAddress()));
                    return;
                }
                String cmd = lin.readLine();
                try {
                    if ("stop".equals(cmd)) {
                        try {
                            this.handleStop(out);
                            ShutdownService.close(socket);
                            ShutdownService.close(this.mSvr);
                            break block28;
                        }
                        finally {
                            System.exit(0);
                        }
                    }
                    if ("fullscan".equals(cmd)) {
                        this.fullscan(lin, out);
                        break block28;
                    }
                    if ("reindex".equals(cmd)) {
                        this.reindex(lin, out);
                        break block28;
                    }
                    if ("loadsvndump".equals(cmd)) {
                        this.loadSvnDump(lin, out);
                        break block28;
                    }
                    if ("backup".equals(cmd)) {
                        this.backup(lin, out);
                        break block28;
                    }
                    if ("rescan".equals(cmd)) {
                        this.rescan(lin, out);
                        break block28;
                    }
                    if ("scannow".equals(cmd)) {
                        this.scannow(lin, out, false);
                        break block28;
                    }
                    if ("scansync".equals(cmd)) {
                        this.scannow(lin, out, true);
                        break block28;
                    }
                    Logs.APP_LOG.warn((Object)("unknown command " + cmd + " from " + socket.getInetAddress()));
                    this.sendStatus(out, 1);
                }
                catch (IOException e2) {
                    Logs.APP_LOG.warn((Object)("Problem with command: " + cmd + "."), (Throwable)e2);
                    this.sendOutput(out, e2.getMessage());
                    this.sendStatus(out, 1);
                }
            }
            catch (IOException e3) {
                Logs.APP_LOG.warn((Object)("problem on control socket from " + socket.getInetAddress()), (Throwable)e3);
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException e4) {
                    Logs.APP_LOG.error((Object)"Unable to close socket");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescan(LineNumberReader lin, OutputStream out) throws IOException {
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        String repname = lin.readLine();
        String start = lin.readLine();
        String end = lin.readLine();
        RepositoryHandle h2 = rm.getRepository(repname);
        Disposer.pushThreadInstance();
        try {
            h2.rescan(start, end);
            this.sendOutput(out, "Rescan requested");
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("Problem requesting rescan: " + e2.getMessage()), (Throwable)e2);
            this.sendOutput(out, e2.getMessage());
            this.sendStatus(out, 1);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void scannow(LineNumberReader lin, OutputStream out, boolean synchronous) throws IOException {
        List<RepositoryHandle> reps = this.parseRepositoriesFromArgs(lin, out);
        for (RepositoryHandle h2 : reps) {
            if (h2.isRunning()) {
                if (synchronous) {
                    this.sendOutput(out, "Scan started: " + h2.getName());
                } else {
                    this.sendOutput(out, "Scan requested: " + h2.getName());
                }
                h2.oneOffScan(synchronous);
                continue;
            }
            this.sendOutput(out, "Repository " + h2.getName() + " is not running");
            Logs.APP_LOG.warn((Object)("cannot scan stopped repository " + h2.getName()));
        }
        if (synchronous) {
            this.sendOutput(out, "Done");
        }
    }

    private void backup(LineNumberReader lin, OutputStream out) throws IOException {
        String backupDir = lin.readLine();
        FishEyeBackup febu = new FishEyeBackup(null);
        try {
            File file;
            if (!StringUtil.nullOrEmpty(backupDir)) {
                file = new File(backupDir);
                febu.backup(file);
            } else {
                file = febu.backup();
            }
            String msg = "Backed up to: " + file.getAbsolutePath();
            this.sendOutput(out, msg);
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)("Problem performing backup: " + e2.getMessage()), (Throwable)e2);
            this.sendOutput(out, e2.getMessage());
            this.sendStatus(out, 1);
        }
        catch (DbException e3) {
            Logs.APP_LOG.error((Object)("Problem re-opening db after backup: " + e3.getMessage()), (Throwable)e3);
            this.sendOutput(out, "An internal problem occurred after backup, you may want to re-start FishEye." + e3.getMessage());
            this.sendStatus(out, 1);
        }
        catch (ConfigException e4) {
            Logs.APP_LOG.error((Object)("Problem re-opening db after backup: " + e4.getMessage()), (Throwable)e4);
            this.sendOutput(out, "An internal problem occurred after backup, you may want to re-start FishEye." + e4.getMessage());
            this.sendStatus(out, 1);
        }
    }

    private void sendStatus(OutputStream out, int status) throws IOException {
        this.sendOutput(out, this.mControlKey);
        this.sendOutput(out, status + "");
    }

    private void sendOutput(OutputStream out, String message) throws IOException {
        out.write((message + "\r\n").getBytes());
        out.flush();
    }

    private void handleStop(OutputStream out) throws IOException {
        this.stopImpl();
        this.sendOutput(out, "FishEye Shutdown successfully");
    }

    private void stopImpl() {
        this.mStopping = true;
        Logs.APP_LOG.info((Object)"shutdown full shutdown");
        if (this.mWS != null) {
            this.mWS.stop();
        }
        RootConfig root = AppConfig.getsConfig();
        root.fullShutdown();
        this.mLock.release();
    }

    public void stop() {
        this.stopImpl();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullscan(LineNumberReader lin, OutputStream out) throws IOException {
        List<RepositoryHandle> reps = this.parseRepositoriesFromArgs(lin, out);
        Disposer.pushThreadInstance();
        try {
            for (RepositoryHandle h2 : reps) {
                if (h2.isRunning()) {
                    try {
                        h2.acquireEngine().requestFullscan();
                    }
                    catch (RepositoryHandle.StateException e2) {
                        Logs.APP_LOG.warn((Object)("cannot fullscan stopped repository " + h2.getName()), (Throwable)e2);
                        this.sendStatus(out, 1);
                    }
                    continue;
                }
                Logs.APP_LOG.warn((Object)("cannot fullscan stopped repository " + h2.getName()));
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex(LineNumberReader lin, OutputStream out) throws IOException {
        List<RepositoryHandle> reps = this.parseRepositoriesFromArgs(lin, out);
        Disposer.pushThreadInstance();
        try {
            for (RepositoryHandle rh : reps) {
                String msg;
                boolean wasRunning = rh.isRunning();
                if (!rh.tryStop(20000L)) {
                    String msg2 = "Could not stop repository '" + rh.getName() + "' within 20 seconds. Re-index aborted.";
                    Logs.APP_LOG.error((Object)msg2);
                    this.sendOutput(out, msg2);
                    this.sendStatus(out, 1);
                    continue;
                }
                try {
                    rh.deleteIndex();
                }
                catch (RepositoryHandle.StateException e2) {
                    msg = "Could not delete cache for repository '" + rh.getName() + "': " + e2.getMessage();
                    Logs.APP_LOG.error((Object)msg);
                    this.sendOutput(out, msg);
                    this.sendStatus(out, 1);
                    continue;
                }
                if (!wasRunning) continue;
                try {
                    AppConfig.getsConfig().getRepositoryManager().runRepository(rh.getName());
                }
                catch (Exception e3) {
                    msg = "Could not restart repository '" + rh.getName() + "': " + e3.getMessage();
                    Logs.APP_LOG.warn((Object)msg);
                    this.sendOutput(out, msg);
                    this.sendStatus(out, 1);
                }
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private List<RepositoryHandle> parseRepositoriesFromArgs(LineNumberReader lin, OutputStream out) throws IOException {
        String repname;
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        List<RepositoryHandle> reps = new LinkedList<RepositoryHandle>();
        boolean zeroArgs = true;
        while (null != (repname = lin.readLine()) && !repname.trim().equals("")) {
            RepositoryHandle h2 = rm.getRepository(repname);
            zeroArgs = false;
            if (h2 != null) {
                reps.add(h2);
                continue;
            }
            String msg = "could not find repository '" + repname + "' specified as argument";
            Logs.APP_LOG.warn((Object)msg);
            this.sendOutput(out, msg);
            this.sendStatus(out, 1);
        }
        if (zeroArgs) {
            reps = rm.getHandles();
        }
        return reps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSvnDump(LineNumberReader lin, OutputStream out) throws IOException {
        block12: {
            String repname = lin.readLine();
            String fname = lin.readLine();
            if (repname == null || fname == null) {
                Logs.APP_LOG.warn((Object)"Could not parse loadsvndump command");
                this.sendStatus(out, 1);
                return;
            }
            File dumpfile = new File(fname);
            if (!dumpfile.isFile()) {
                Logs.APP_LOG.warn((Object)("could not find file for loadsvndump " + dumpfile.getAbsolutePath()));
                this.sendStatus(out, 1);
                return;
            }
            RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
            RepositoryHandle h2 = rm.getRepository(repname);
            if (h2 == null) {
                Logs.APP_LOG.warn((Object)("could not find repository " + repname + " specified as argument to loadsvndump"));
                this.sendStatus(out, 1);
                return;
            }
            Disposer.pushThreadInstance();
            try {
                if (h2.isRunning()) {
                    try {
                        RepositoryEngine engine = h2.acquireEngine();
                        if (engine instanceof SvnRepositoryEngine) {
                            SvnRepositoryEngine svne = (SvnRepositoryEngine)engine;
                            try {
                                svne.loadDump(dumpfile);
                            }
                            catch (Exception e2) {
                                Logs.APP_LOG.error((Object)"Unable to load SVN dump", (Throwable)e2);
                                this.sendStatus(out, 1);
                            }
                            break block12;
                        }
                        Logs.APP_LOG.warn((Object)("cannot loadsvndump non-svn repository " + repname));
                        this.sendStatus(out, 1);
                    }
                    catch (RepositoryHandle.StateException e3) {
                        Logs.APP_LOG.warn((Object)("cannot loadsvndump stopped repository " + repname), (Throwable)e3);
                        this.sendStatus(out, 1);
                    }
                    break block12;
                }
                Logs.APP_LOG.warn((Object)("cannot loadsvndump stopped repository " + repname));
                this.sendStatus(out, 1);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    private static void close(ServerSocket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void close(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setWebServer(WebServer ws) {
        this.mWS = ws;
    }
}

