/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cvsrep.Annotator;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.LazyChangeSet;
import com.cenqua.fisheye.cvsrep.cache.PartialCvsCSID;
import com.cenqua.fisheye.cvsrep.cache.RepositoryIndex;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedCvsRepository
extends BaseRevisionCache {
    private final RevisionInfoCache mDB;
    private final RepositoryIndex mIndex;
    private final CvsRepository mRep;
    private long cacheSerialNumber = 1L;

    public CachedCvsRepository(RevisionInfoCache DB, LuceneConnection index0, CvsRepository rep, boolean contentIndexingEnabled) {
        this.mDB = DB;
        this.mIndex = new RepositoryIndex(index0, DB, rep, contentIndexingEnabled, this.isCaseSensitive());
        this.mRep = rep;
    }

    @Override
    public long getCacheSerialNumber() {
        return this.cacheSerialNumber;
    }

    public void setCacheSerialNumber(long cacheSerialNumber) {
        this.cacheSerialNumber = cacheSerialNumber;
    }

    public RepositoryIndex getIndex() {
        return this.mIndex;
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        return this.mDB.listFiles(dir);
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        return this.mDB.listDirs(dir);
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        return this.mDB.isFile(path);
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        return path.isRoot() || this.mDB.isDir(path);
    }

    @Override
    public List<String> findRecentChangeSetIds(RecentChangesParams params) throws DbException {
        return this.mIndex.findRecentChangeSetIds(params);
    }

    @Override
    public List findRecentChangeSets(RecentChangesParams params) throws DbException {
        long t0 = System.currentTimeMillis();
        List<String> ids = this.findRecentChangeSetIds(params);
        long t1 = System.currentTimeMillis();
        Logs.PERF_LOG.info((Object)("recent changesets in " + (t1 - t0) + "ms (" + ids.size() + " results)"));
        ArrayList<ChangeSet> results = new ArrayList<ChangeSet>(ids.size());
        for (String id : ids) {
            ChangeSet cs = this.getChangeSet(id);
            results.add(cs);
        }
        return results;
    }

    public FileRevision getRevisionInfo(RevInfoKey key) throws DbException {
        return this.mDB.findRevInfo(key);
    }

    public FileRevision getRevisionInfo(int revid) throws DbException {
        return this.mDB.findRevInfo(revid);
    }

    @Override
    public FileRevision getFileRevision(int revid) throws DbException {
        return this.getRevisionInfo(revid);
    }

    @Override
    public FileRevision getFileRevision(RevInfoKey rkey) throws DbException {
        return this.getRevisionInfo(rkey);
    }

    @Override
    public FileHistory getFileHistory(Path lpath, boolean physicalOnly) throws DbException {
        return this.mDB.findFileHistory(lpath);
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        return this.getFileHistory(path);
    }

    @Override
    public Blame getBlame(RevInfoKey rk) throws DbException {
        RcsFileHistoryFactory.Result hr;
        try {
            hr = this.mRep.getFileHistory(rk.getPath());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        catch (RCSParser.ParseException e3) {
            throw new DbException(e3);
        }
        FileHistory hist = this.getFileHistory(rk.getPath());
        Annotator ann = new Annotator(hist, hr.getTree());
        ann.annotate(new Revision(rk.getRev()));
        return new Blame(ann.getChunks());
    }

    @Override
    public String getRepositoryType() {
        return "cvs";
    }

    @Override
    public ChangeSet getChangeSet(String csid) throws DbException {
        CvsCSID id = CvsCSID.parse(csid);
        return id == null ? null : this.getChangeSet(id);
    }

    @Override
    public String getChangeSetId(RevInfoKey rk) throws DbException {
        CvsCSID id = this.mDB.getChangeSetId(rk);
        return id == null ? null : id.toString();
    }

    @Override
    public long getLastModifiedDate() throws DbException {
        return this.mDB.getLastModified();
    }

    @Override
    public void touchLastModifiedDate() throws DbException {
        this.mDB.touch();
    }

    public ChangeSet getChangeSet(CvsCSID csid) throws DbException {
        if (csid == null) {
            return new LazyChangeSet(null, new TIntArrayList(1), this.mDB);
        }
        TIntArrayList revids = this.mDB.getChangeSet(csid);
        return new LazyChangeSet(csid, revids, this.mDB);
    }

    @Override
    public String getImpliedBranch(Path path) {
        return null;
    }

    @Override
    public AndQuery3 findRevisionsUnderDirQuery3(Path dir, boolean findLogical) {
        return CommonQuery3Helper.findRevisionsUnderDirQuery3(dir, this.isCaseSensitive());
    }

    @Override
    public List<String> getSimilarChangeSetIds(String csid) throws DbException {
        CvsCSID id = CvsCSID.parse(csid);
        if (id != null) {
            return this.mDB.getSimilarChangeSetIds(id);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialIdStr) throws DbException {
        PartialCvsCSID partialId = PartialCvsCSID.parse(partialIdStr);
        if (partialId != null) {
            return this.mIndex.findSimilarPartialChangeSetIds(partialId);
        }
        return Collections.emptyList();
    }

    @Override
    public Charset getTextEncoding(RevInfoKey key) {
        return this.mRep.getCharset();
    }

    @Override
    public void getTextRevision(RevInfoKey key, OutputStream aOut, String kopt, String symrev) throws IOException, DbException {
        try {
            CvsRevInfo info = this.mDB.findRevInfo(key);
            if (info == null) {
                throw new DbException("revision not found: " + key);
            }
            KeywordExpansion k = kopt == null ? null : KeywordExpansion.parse(kopt);
            KeywordExpansion.KeywordExpansionInfo ki = info.makeKeywordExpansionInfo(symrev);
            this.mRep.getTextRevision(info.getPath(), info.getCvsRevision(), ki, aOut, k);
        }
        catch (RCSParser.ParseException e2) {
            Logs.APP_LOG.warn((Object)"problem getting text revision", (Throwable)e2);
            throw new IOException(e2.getMessage());
        }
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, OutputStream aOut) throws IOException, DbException {
        try {
            CvsRevInfo info = this.mDB.findRevInfo(key);
            if (info == null) {
                throw new DbException("revision not found: " + key);
            }
            this.mRep.getBinaryRevision(info.getPath(), info.getCvsRevision(), aOut);
        }
        catch (RCSParser.ParseException e2) {
            Logs.APP_LOG.warn((Object)"problem getting binary revision", (Throwable)e2);
            throw new IOException(e2.getMessage());
        }
    }

    public File getFilesystemFileForPath(Path path) throws FileNotFoundException {
        return this.mRep.getFilesystemFileForPath(path);
    }

    @Override
    public InfinityDbHandle getInfDb() {
        return this.mDB.getInfDb();
    }

    @Override
    public CommonStringTables getCommonStringTables() {
        return this.mDB.getCommonStringTables();
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.mDB.getCommonRevInfoDAO();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.mDB.isCaseSensitive();
    }

    @Override
    public boolean showAuthorLinecount() {
        return true;
    }

    public RcsFileHistoryFactory.Result getFileHistoryResult(Path path) throws IOException, RCSParser.ParseException {
        return this.mRep.getFileHistory(path);
    }
}

