/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.cache.CVSRecentChangesSearcher;
import com.cenqua.fisheye.cvsrep.cache.PartialCvsCSID;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.web.WaybackSpec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryIndex {
    private final LuceneConnection mIndex;
    private final RevisionInfoCache mDB;
    private final CvsRepository mRep;
    private final boolean contentIndexingEnabled;
    private final boolean caseSensitive;

    public RepositoryIndex(LuceneConnection index0, RevisionInfoCache DB, CvsRepository rep, boolean contentIndexingEnabled, boolean caseSensitive) {
        this.mIndex = index0;
        this.mDB = DB;
        this.mRep = rep;
        this.contentIndexingEnabled = contentIndexingEnabled;
        this.caseSensitive = caseSensitive;
    }

    public void indexFiles(final List<RcsFileHistory> histories) throws DbException {
        this.mIndex.withWriter(0, new LuceneConnection.WriterAction(){

            public void perform(IndexWriter idx0) throws DbException {
                CommonIndexer indexer = new CommonIndexer();
                for (RcsFileHistory history : histories) {
                    for (RcsRevisionInfo r : history.getRevisions()) {
                        if (!r.isNewlyAdded()) continue;
                        indexer.insertNew(idx0, r.getRevID(), r);
                    }
                }
            }
        });
        for (RcsFileHistory history : histories) {
            this.indexContents(history);
        }
        this.mIndex.flushWriter();
    }

    private void indexContents(final RcsFileHistory history) throws DbException {
        final RcsRevisionInfo headRev = history.getRevision(history.getHead());
        if (!headRev.isNewlyAdded()) {
            return;
        }
        if (this.contentIndexingEnabled) {
            this.mIndex.withReaderAndDeletes(1, new LuceneConnection.ReaderAction(){

                public void perform(IndexReader reader) throws IOException, DbException {
                    CommonIndexer indexer = new CommonIndexer();
                    Collection<RcsRevisionInfo> revs = history.getRevisions();
                    Logs.APP_LOG.debug((Object)("deleting old documents # " + revs.size()));
                    for (RcsRevisionInfo r : revs) {
                        indexer.deleteDocumentsForRevid(reader, r.getRevID());
                    }
                }
            });
            if (!this.shouldIndex(headRev)) {
                return;
            }
            this.mIndex.withWriter(1, new LuceneConnection.WriterAction(){

                public void perform(IndexWriter writer) throws IOException, DbException {
                    Logs.APP_LOG.debug((Object)("indexing " + headRev.getRevInfoKey()));
                    RepositoryIndex.this.indexContents(writer, headRev);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexContents(IndexWriter writer, RcsRevisionInfo info) throws IOException {
        CommonIndexer indexer = new CommonIndexer();
        File contentsFile = File.createTempFile("fisheye", null);
        FileInputStream contents = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(contentsFile);
            this.mRep.getTextRevision(info.getPath(), info.getCvsRevision(), info.makeKeywordExpansionInfo(), out, null);
            ((OutputStream)out).close();
            contents = new FileInputStream(contentsFile);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)contents, this.mRep.getCharset()));
            indexer.indexContents(writer, info.getRevID(), info, in);
        }
        catch (Exception e2) {
            try {
                Logs.APP_LOG.warn((Object)("could not index contents of " + info.getPath() + " " + info.getRevision() + ". Revision contents not indexed"), (Throwable)e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(out);
                IOHelper.close(contents);
                contentsFile.delete();
                throw throwable;
            }
            IOHelper.close(out);
            IOHelper.close(contents);
            contentsFile.delete();
        }
        IOHelper.close(out);
        IOHelper.close(contents);
        contentsFile.delete();
    }

    public void flush() throws DbException {
        this.mIndex.flushWriter();
    }

    public List<String> findRecentChangeSetIds(RecentChangesParams params) throws DbException {
        CVSRecentChangesSearcher rcSearcher = new CVSRecentChangesSearcher(this.mIndex, this.mDB, params, this.caseSensitive);
        try {
            return rcSearcher.findRecentChangeSets();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public List<String> findSimilarPartialChangeSetIds(PartialCvsCSID partialId) throws DbException {
        RecentChangesParams params = new RecentChangesParams();
        boolean isConstrained = false;
        WaybackSpec wb = new WaybackSpec();
        if (partialId.getBranch() != null) {
            wb.setBranch(partialId.getBranch());
            isConstrained = true;
        }
        if (partialId.getAuthor() != null) {
            wb.setAuthor(partialId.getAuthor());
            isConstrained = true;
        }
        if (isConstrained) {
            params.setConstraint(wb.getConstraintQuery3(false));
        }
        long slop = 122880L;
        params.setMinDate(partialId.getDate() - 122880L);
        params.setMaxDate(partialId.getDate() + 122880L);
        return this.findRecentChangeSetIds(params);
    }

    private boolean shouldIndex(RcsRevisionInfo headRev) {
        if (headRev.isDead() || headRev.isBinary()) {
            return false;
        }
        int hc = headRev.getFile().getHeadByteCount();
        if ((long)hc >= 0x500000L) {
            Logs.APP_LOG.warn((Object)("Not indexing contents of HEAD of " + headRev.getPath() + " because its size (" + hc + "B) is too large (limit is 5MB)"));
            return false;
        }
        return true;
    }
}

