/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache.infdb;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.cache.CachedChangesetUpdater;
import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsDirInfo;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.MutableRevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.DirInfoEAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.FileHistEAV;
import com.cenqua.fisheye.cvsrep.cache.infdb.RevInfoEAV;
import com.cenqua.fisheye.infinitydb.InfDbCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfDbRevisionInfoCache
extends InfDbCache
implements MutableRevisionInfoCache {
    private UniqueStringTable mChangesetIdsDB;
    private CommonStringTables commonTables;
    private RevInfoEAV mRevInfoEAV;
    private DirInfoEAV mDirInfoEAV;
    private FileHistEAV mFileHistEAV;
    private volatile Long lastModified;
    private boolean caseSensitive;

    @Override
    public void open() throws IOException {
        super.open();
        this.mChangesetIdsDB = this.createStringTable(EAV.CHANGESET_ID_DB);
        this.commonTables = new CommonStringTables(this.getDatabase());
        this.mRevInfoEAV = new RevInfoEAV(this.getDatabase(), this.commonTables, this.caseSensitive);
        this.mDirInfoEAV = new DirInfoEAV(this.getDatabase(), this.commonTables, this.caseSensitive);
        this.mFileHistEAV = new FileHistEAV(this.getDatabase(), this.commonTables.pathDB, this.mRevInfoEAV);
    }

    @Override
    public void touch() throws DbException {
        long ts = System.currentTimeMillis();
        this.setLastModified(ts);
    }

    FileHistEAV getFileHistEAV() {
        return this.mFileHistEAV;
    }

    @Override
    public long getLastModified() throws DbException {
        Long lm = this.lastModified;
        if (lm == null) {
            this.lastModified = lm = Long.valueOf(this.getLongProperty("LAST_MODIFIED", -1L));
        }
        return lm;
    }

    private void setLastModified(long v) throws DbException {
        this.setLongValue(EAV.PROP_STORE, "LAST_MODIFIED", v);
        this.lastModified = v;
    }

    @Override
    public void putDirInfo(CvsDirInfo d2) throws DbException {
        try {
            this.mDirInfoEAV.update(d2);
            this.touch();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public DirInfo findDirInfo(Path path) throws DbException {
        return this.mDirInfoEAV.load(path);
    }

    @Override
    public CvsDirInfo findCvsDirInfo(Path path) throws DbException {
        try {
            return this.mDirInfoEAV.loadCvsInfo(path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        return this.mDirInfoEAV.exists(path);
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        return this.mRevInfoEAV.listDirs(dir);
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        return this.mRevInfoEAV.listFiles(dir);
    }

    @Override
    public long getLongProperty(String key, long defaultValue) throws DbException {
        return this.getLongValue(EAV.PROP_STORE, key, defaultValue);
    }

    @Override
    public void index(List<RcsFileHistory> histories) throws DbException {
        try {
            for (RcsFileHistory history : histories) {
                this.mRevInfoEAV.update(history);
                this.mFileHistEAV.update(history);
            }
            this.touch();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsRevInfo findRevInfo(RevInfoKey key) throws DbException {
        try {
            return this.mRevInfoEAV.load(key);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public FileHistory findFileHistory(Path path) throws DbException {
        try {
            return this.mFileHistEAV.load(path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        try {
            return this.mFileHistEAV.exists(path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsRevInfo findRevInfo(int revid) throws DbException {
        try {
            return this.mRevInfoEAV.load(revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void appendToChangeSet(CvsCSID csid, List<CvsRevInfo> revInfos) throws DbException {
        for (CvsRevInfo ri : revInfos) {
            this.mRevInfoEAV.updateChangeset(ri, csid);
        }
        this.touch();
    }

    @Override
    public CvsCSID createNewChangeSetID(CvsRevInfo marker) throws DbException {
        try {
            CvsCSID id;
            boolean found;
            int count = 0;
            while (found = this.changesetExists(id = new CvsCSID(marker.getBranch(), marker.getAuthor(), marker.getDate(), count++))) {
            }
            this.mChangesetIdsDB.add(id.toString());
            this.mRevInfoEAV.setAsChangesetMarker(marker);
            this.touch();
            return id;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private boolean changesetExists(CvsCSID id) throws DbException {
        return this.mChangesetIdsDB.find(id.toString()) != -1L;
    }

    @Override
    public CvsCSID getChangeSetId(int revid) throws DbException {
        try {
            return this.mRevInfoEAV.getChangeSet(revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public CvsCSID getChangeSetId(RevInfoKey rk) throws DbException {
        try {
            int revid = this.mRevInfoEAV.findRevID(rk);
            return this.mRevInfoEAV.getChangeSet(revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public List<String> getSimilarChangeSetIds(CvsCSID patternID) throws DbException {
        CvsCSID id;
        LinkedList<String> result = new LinkedList<String>();
        String branch = patternID.getBranch();
        String author = patternID.getAuthor();
        long date = patternID.getDate();
        int count = 0;
        while (this.changesetExists(id = new CvsCSID(branch, author, date, count++))) {
            String idstr = id.toString();
            result.add(idstr);
        }
        return result;
    }

    @Override
    public TIntArrayList getChangeSet(CvsCSID csid) throws DbException {
        if (csid == null) {
            return new TIntArrayList(1);
        }
        try {
            return this.mRevInfoEAV.getChangeSetRevids(csid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean changesetContainsPath(CvsCSID csid, Path path) throws DbException {
        try {
            return this.mRevInfoEAV.changesetContainsPath(csid, path);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getCommentId(String comment) throws DbException {
        return this.commonTables.commentDB.find(comment);
    }

    @Override
    public boolean scanForChangesets(long noLaterThan, RepositoryStatus st) throws DbException {
        CachedChangesetUpdater cupdater = new CachedChangesetUpdater(st, this.getDatabase(), this);
        boolean foundChanges = false;
        do {
            cupdater.processSomeChangesets(noLaterThan);
            foundChanges |= cupdater.foundChanges();
            this.commit();
        } while (cupdater.foundChanges());
        this.touch();
        return foundChanges;
    }

    @Override
    public InfinityDbHandle getInfDb() {
        return this.getDatabase();
    }

    @Override
    public CommonStringTables getCommonStringTables() {
        return this.commonTables;
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.mRevInfoEAV.getCommonRevInfoDAO();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

