/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearcher;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermQuickSearch
implements QuickSearcher.SearchAlgorithm {
    private final _EntityClass[] entities;
    private final _ItemSpace db;
    private final RevisionCache cache;
    private final boolean findLogical;

    public TermQuickSearch(QuickSearcher searcher, _EntityClass entity, boolean findLogical) throws DbException {
        this(searcher, new _EntityClass[]{entity}, findLogical);
    }

    public TermQuickSearch(QuickSearcher searcher, _EntityClass[] entities, boolean findLogical) throws DbException {
        this.entities = entities;
        this.findLogical = findLogical;
        RepositoryEngine eng = searcher.getEngine();
        this.cache = eng.getRevisionCache();
        this.db = eng.getRevisionCache().getInfDb().get();
    }

    @Override
    public QuickSearchResults.TermResults search(Path path, List<String> origParams) throws IOException, DbException {
        if (origParams.isEmpty()) {
            return null;
        }
        Set<String> params = this.matchingTerms(path, origParams);
        if (params.isEmpty()) {
            return null;
        }
        LuceneConnection conn = null;
        QuickSearchResults.TermResults matches = new QuickSearchResults.TermResults();
        AndQuery3 unionQuery = this.cache.findRevisionsUnderDirQuery3(path, this.findLogical);
        for (String term : params) {
            AndQuery3 bq = this.cache.findRevisionsUnderDirQuery3(path, this.findLogical);
            Query3 query = this.makeTermQuery(term);
            bq.addClause(query);
            int count = bq.countMatches(this.db, conn);
            matches.addMatch(term, count);
            if (count <= 0) continue;
            unionQuery.addClause(query);
        }
        if (matches.getResultCount() > 0) {
            int count = unionQuery.countMatches(this.db, conn);
            matches.setUnionResultCount(count);
        }
        return matches;
    }

    private Query3 makeTermQuery(String term) {
        if (this.entities.length == 1) {
            return new TermQuery3(this.entities[0], term, null);
        }
        OrQuery3 q = new OrQuery3();
        for (_EntityClass entity : this.entities) {
            q.addClause(new TermQuery3(entity, term, null));
        }
        return q;
    }

    private Set<String> matchingTerms(Path path, final List<String> origParams) throws DbException {
        final LinkedHashSet<String> result = new LinkedHashSet<String>(origParams.size());
        for (_EntityClass entity : this.entities) {
            this.cache.visitMatchingStringTerms(path, this.findLogical, entity, new CommonQuery3Helper.StringVisitor(){

                public boolean visit(String text) {
                    for (String param : origParams) {
                        if (!text.equalsIgnoreCase(param)) continue;
                        result.add(text);
                    }
                    return true;
                }
            });
        }
        return result;
    }
}

