/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.rep.DbException;
import gnu.trove.TIntArrayList;
import java.util.NoSuchElementException;

public class SimpleSearchResults
extends SearchResults {
    private Object[] groupStarts;
    private final TIntArrayList revids;
    private final String type;

    public SimpleSearchResults(RevisionCache mRep, String type, TIntArrayList revids) {
        super(mRep);
        this.revids = revids;
        this.type = type;
    }

    public SimpleSearchResults(RevisionCache mRep, String type, TIntArrayList revids, Object[] groupStarts) {
        super(mRep);
        this.revids = revids;
        this.type = type;
        this.groupStarts = groupStarts;
    }

    public int size() {
        return this.revids.size();
    }

    public boolean isGrouped() {
        return this.groupStarts != null;
    }

    public String getType() {
        return this.type;
    }

    public SearchResults.RevisionResultsIterator iterateRevisions(int start) throws DbException {
        return new MyIterator(start);
    }

    class MyIterator
    extends SearchResults.RevisionResultsIterator {
        private int next = 0;
        private Object currentGroup;
        private boolean isGroupStart;

        MyIterator(int start) {
            this.next = start;
        }

        public boolean hasNext() {
            return this.next < SimpleSearchResults.this.revids.size();
        }

        public int nextItemId() throws Exception {
            if (this.next >= SimpleSearchResults.this.size()) {
                throw new NoSuchElementException("at end of list");
            }
            int revid = SimpleSearchResults.this.revids.get(this.next);
            if (SimpleSearchResults.this.groupStarts == null) {
                this.isGroupStart = true;
            } else {
                Object g2 = SimpleSearchResults.this.groupStarts[this.next];
                if (g2 == null) {
                    this.isGroupStart = false;
                } else {
                    this.isGroupStart = true;
                    this.currentGroup = g2;
                }
            }
            ++this.next;
            return revid;
        }

        public Object currentGroup() {
            return this.currentGroup;
        }

        public boolean isStartOfGroup() {
            return this.isGroupStart;
        }
    }
}

