/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.search.ClauseVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorsClause
extends Clause {
    private final List<String> mAuthors;

    public AuthorsClause(List<String> authors) {
        this.mAuthors = authors;
    }

    public AuthorsClause(String author) {
        this.mAuthors = new ArrayList<String>();
        this.mAuthors.add(author);
    }

    @Override
    public void accept(ClauseVisitor visitor) {
        visitor.visitAuthorsClause(this);
    }

    public Iterator getAuthors() {
        return this.mAuthors.iterator();
    }

    @Override
    public void toString(StringBuffer buf) {
        buf.append("author ");
        if (this.mAuthors.size() == 1) {
            buf.append("= ");
            AuthorsClause.quoteString(this.mAuthors.get(0), buf);
        } else {
            buf.append("in (");
            String sep = "";
            for (String au : this.mAuthors) {
                buf.append(sep);
                AuthorsClause.quoteString(au, buf);
                sep = ", ";
            }
            buf.append(")");
        }
    }
}

