/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hunk
implements Comparable<Hunk> {
    private final int mFrom;
    private final int mFromCount;
    private final int mTo;
    private final int mToCount;
    private boolean ignored;

    public Hunk(int aOrigIndex, int aRevIndex, int aOrigCount, int aRevCount) {
        this.mFrom = aOrigIndex;
        this.mFromCount = aOrigCount;
        this.mTo = aRevIndex;
        this.mToCount = aRevCount;
    }

    public static Hunk createAddHunk(int fromLine, int toLine, int count) {
        return new Hunk(fromLine - 1, toLine, 0, count);
    }

    public static Hunk createDeleteHunk(int fromLine, int toLine, int count) {
        return new Hunk(fromLine, toLine - 1, count, 0);
    }

    public int getFrom() {
        return this.mFrom;
    }

    public int getFromCount() {
        return this.mFromCount;
    }

    public int getTo() {
        return this.mTo;
    }

    public int getToCount() {
        return this.mToCount;
    }

    public boolean isDelete() {
        return this.mToCount == 0;
    }

    public boolean isAdd() {
        return this.mFromCount == 0;
    }

    public boolean isChange() {
        return !this.isAdd() && !this.isDelete();
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hunk hunk = (Hunk)o;
        if (this.ignored != hunk.ignored) {
            return false;
        }
        if (this.mFrom != hunk.mFrom) {
            return false;
        }
        if (this.mFromCount != hunk.mFromCount) {
            return false;
        }
        if (this.mTo != hunk.mTo) {
            return false;
        }
        return this.mToCount == hunk.mToCount;
    }

    public int hashCode() {
        int result = this.mFrom;
        result = 29 * result + this.mFromCount;
        result = 29 * result + this.mTo;
        result = 29 * result + this.mToCount;
        result = 29 * result + (this.ignored ? 1 : 0);
        return result;
    }

    public String toString() {
        String mod;
        String string = this.isDelete() ? "d" : (mod = this.isAdd() ? "a" : "c");
        if (this.ignored) {
            mod = mod + "-ignored";
        }
        return mod + "<" + this.mFrom + ":" + this.mFromCount + " , " + this.mTo + ":" + this.mToCount + ">";
    }

    public Hunk getReverse() {
        return new Hunk(this.mTo, this.mFrom, this.mToCount, this.mFromCount);
    }

    @Override
    public int compareTo(Hunk hunk) {
        return this.mFrom - hunk.getFrom();
    }

    public int getFromIndex() {
        if (this.mFromCount == 0) {
            return this.mFrom;
        }
        return this.mFrom - 1;
    }

    public int getToIndex() {
        if (this.mToCount == 0) {
            return this.mTo;
        }
        return this.mTo - 1;
    }
}

