/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.RemappingDiffSequences;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.StringUtil;
import gnu.trove.TIntArrayList;
import java.util.List;

public class RegionListDiffSequences
extends RemappingDiffSequences {
    private final List mOrig;
    private final List mRevised;
    private final CharSequence mOrigSequence;
    private final CharSequence mRevisedSequence;

    public RegionListDiffSequences(RegionList orig, CharSequence origSequence, RegionList revised, CharSequence revisedSequence) {
        this(orig.asList(), origSequence, revised.asList(), revisedSequence);
    }

    public RegionListDiffSequences(List orig, CharSequence origSequence, List revised, CharSequence revisedSequence) {
        super(false);
        this.mOrig = orig;
        this.mRevised = revised;
        this.mOrigSequence = origSequence;
        this.mRevisedSequence = revisedSequence;
        TIntArrayList origHashes = new TIntArrayList(this.mOrig.size());
        TIntArrayList revisedHashes = new TIntArrayList(this.mRevised.size());
        RegionListDiffSequences.scanRegions(orig, this.mOrigSequence, origHashes);
        RegionListDiffSequences.scanRegions(revised, this.mRevisedSequence, revisedHashes);
        this.setup(origHashes, revisedHashes);
    }

    private static void scanRegions(List regions, CharSequence input, TIntArrayList hashes) {
        for (Region region : regions) {
            CharSequence s = RegionListDiffSequences.getCharSequence(input, region);
            hashes.add(StringUtil.stringHashCode(s));
        }
    }

    protected boolean equalImpl(int aOriginalIndex, int aRevisionIndex) {
        Region a2 = (Region)this.mOrig.get(aOriginalIndex);
        Region b2 = (Region)this.mRevised.get(aRevisionIndex);
        CharSequence sa = RegionListDiffSequences.getCharSequence(this.mOrigSequence, a2);
        CharSequence sb = RegionListDiffSequences.getCharSequence(this.mRevisedSequence, b2);
        return StringUtil.equal(sa, sb);
    }

    private static CharSequence getCharSequence(CharSequence s, Region a2) {
        return s.subSequence(a2.getStart(), a2.getEnd());
    }

    protected boolean ignoreOriginalLine(int i2) {
        return false;
    }

    protected boolean ignoreRevisedLine(int i2) {
        return false;
    }
}

