/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._EmptyItemSpace;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import java.io.IOException;

public class BitSetItemSpace
extends _ItemSpace {
    private static final int maxItemLength;
    private final SortedIntSet bs;

    public BitSetItemSpace(SortedIntSet bs) {
        this.bs = bs;
    }

    public boolean exists(_Cu cu) throws IOException {
        if (cu.length() == 0) {
            return false;
        }
        if (cu.typeAt(0) != 7) {
            throw new IOException("expected a cursor with just a long");
        }
        int pend = cu.skipLong(0);
        if (cu.length() > pend) {
            throw new IOException("expected a cursor with just a long");
        }
        int val = (int)cu.longAt(0);
        return this.bs.get(val);
    }

    public int move(_Cu cu, int pl, boolean isFirst, boolean isForwards, boolean isLazy) throws IOException {
        int val;
        boolean existsCheck = false;
        if (pl == cu.length() && pl > 0) {
            existsCheck = true;
        } else if (pl != 0) {
            throw new IOException("protected length must be zero: " + pl);
        }
        boolean wasEmpty = false;
        if (cu.length() == 0) {
            wasEmpty = true;
            val = isForwards ? 0 : this.bs.length();
        } else {
            if (cu.typeAt(0) != 7) {
                throw new IOException("expected a cursor with just a long");
            }
            int pend = cu.skipLong(0);
            if (cu.length() > pend) {
                throw new IOException("expected a cursor with just a long");
            }
            val = (int)cu.longAt(0);
        }
        if ((isFirst || wasEmpty) && this.bs.get(val)) {
            if (wasEmpty) {
                if (!existsCheck) {
                    cu.setLength(0);
                    cu.append(val);
                }
                return 0;
            }
            return cu.length();
        }
        int next = isForwards ? this.bs.nextSetBit(val + 1) : this.bs.prevSetBit(val - 1);
        if (next == -1) {
            return -1;
        }
        if (!existsCheck) {
            cu.setLength(0);
            cu.append(next);
        }
        return 0;
    }

    public long getMaxDiff(_Cu cu1, _Cu cu2) throws IOException {
        return this.bs.length();
    }

    public long getMinDiff(_Cu cu1, _Cu cu2) throws IOException {
        return 0L;
    }

    public int getMaxItemLength() {
        return maxItemLength;
    }

    public void insert(_Cu cu) throws IOException {
        throw new IOException("ItemSpace not writable");
    }

    public void delete(_Cu cu) throws IOException {
        throw new IOException("ItemSpace not writable");
    }

    static {
        _EmptyItemSpace e2 = new _EmptyItemSpace();
        maxItemLength = e2.getMaxItemLength();
    }
}

