/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.infinitydb.BitSetItemSpace;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.lucene.join.LeftJoinQuery;
import com.cenqua.fisheye.lucene.join.RightJoinEnum;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneJoinQuery3
extends Query3 {
    private final Query luceneQuery;
    private final int requiredIndex;

    public LuceneJoinQuery3(Query luceneQuery, int requiredIndex) {
        this.luceneQuery = luceneQuery;
        this.requiredIndex = requiredIndex;
    }

    protected void calculateRequiredReaders(TIntHashSet requiredReaders) {
        requiredReaders.add(this.requiredIndex);
    }

    protected _ItemSpace asItemSpace(_ItemSpace source, IndexReader[] readers) throws DbException {
        try {
            IndexReader reader = readers[this.requiredIndex];
            IndexSearcher searcher = new IndexSearcher(reader);
            final BitSet docids = new BitSet(reader.maxDoc());
            searcher.search(this.luceneQuery, new HitCollector(){

                public void collect(int doc, float score) {
                    docids.set(doc);
                }
            });
            RightJoinEnum revidEnum = LeftJoinQuery.makeRightEnum(docids, reader, "revid");
            revidEnum.reset();
            SortedIntSet revids = LuceneJoinQuery3.makeBitSet();
            while (revidEnum.hasNext()) {
                Term term = revidEnum.term();
                revids.set(Integer.parseInt(term.text()));
            }
            return new BitSetItemSpace(revids);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void toString(StringBuffer s) {
        s.append("Lucene(").append(this.luceneQuery).append(")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneJoinQuery3 that = (LuceneJoinQuery3)o;
        if (this.requiredIndex != that.requiredIndex) {
            return false;
        }
        return this.luceneQuery.equals(that.luceneQuery);
    }

    public int hashCode() {
        int result = this.luceneQuery.hashCode();
        result = 29 * result + this.requiredIndex;
        return result;
    }
}

