/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.license.CenquaLicenseWrapper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.license.CenquaLicense;
import java.io.File;

public class FishEyeLicense
extends CenquaLicenseWrapper {
    public static final String FREE_UPGRADES_SPAN_KEY = "fisheye.upgradespan";
    public static final String MAX_USERS_KEY = "fisheye.maxusers";
    private boolean maxUsersLimited = false;
    private int maxUsers;

    public FishEyeLicense(CenquaLicense cenquaLicense, File source) {
        super(cenquaLicense, source);
        this.setupProps();
    }

    private void setupProps() {
        String s = this.getProperty(MAX_USERS_KEY);
        if (!StringUtil.nullOrEmpty(s)) {
            this.maxUsersLimited = true;
            try {
                this.maxUsers = Integer.parseInt(s);
                if (this.maxUsers >= 10000 || this.maxUsers == 0) {
                    this.maxUsersLimited = false;
                }
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.warn((Object)"Problem parsing license: fisheye.maxusers", (Throwable)e2);
            }
        }
    }

    public boolean isNumberOfUsersLimited() {
        return this.maxUsersLimited;
    }

    public int getMaxNumberOfUsers() {
        return this.maxUsers;
    }
}

